/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.osgi;

import java.io.Closeable;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.karaf.shell.api.console.CommandLoggingFilter;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.impl.action.command.ManagerImpl;
import org.apache.karaf.shell.impl.action.osgi.CommandExtender;
import org.apache.karaf.shell.impl.console.SessionFactoryImpl;
import org.apache.karaf.shell.impl.console.TerminalFactory;
import org.apache.karaf.shell.impl.console.osgi.Converters;
import org.apache.karaf.shell.impl.console.osgi.EventAdminListener;
import org.apache.karaf.shell.impl.console.osgi.LocalConsoleManager;
import org.apache.karaf.shell.impl.console.osgi.LoggingCommandSessionListener;
import org.apache.karaf.shell.impl.console.osgi.secured.SecuredSessionFactoryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final String START_CONSOLE = "karaf.startLocalConsole";
    private ThreadIOImpl threadIO;
    private SessionFactoryImpl sessionFactory;
    private ServiceRegistration sessionFactoryRegistration;
    private CommandExtender actionExtender;
    private Closeable eventAdminListener;
    private TerminalFactory terminalFactory;
    private LocalConsoleManager localConsoleManager;
    ServiceTracker<CommandLoggingFilter, CommandLoggingFilter> filterTracker;

    public void start(final BundleContext context) throws Exception {
        this.threadIO = new ThreadIOImpl();
        this.threadIO.start();
        this.sessionFactory = new SecuredSessionFactoryImpl(context, this.threadIO);
        this.sessionFactory.getCommandProcessor().addConverter(new Converters(context));
        this.sessionFactory.getCommandProcessor().addConstant(".context", context.getBundle(0L).getBundleContext());
        final CopyOnWriteArraySet<CommandLoggingFilter> listeners = new CopyOnWriteArraySet<CommandLoggingFilter>();
        this.filterTracker = new ServiceTracker(context, CommandLoggingFilter.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<CommandLoggingFilter, CommandLoggingFilter>(){

            public CommandLoggingFilter addingService(ServiceReference<CommandLoggingFilter> reference) {
                CommandLoggingFilter service = (CommandLoggingFilter)context.getService(reference);
                listeners.add(service);
                return service;
            }

            public void modifiedService(ServiceReference<CommandLoggingFilter> reference, CommandLoggingFilter service) {
            }

            public void removedService(ServiceReference<CommandLoggingFilter> reference, CommandLoggingFilter service) {
                listeners.remove(service);
                context.ungetService(reference);
            }
        });
        this.filterTracker.open();
        LoggingCommandSessionListener loggingCommandSessionListener = new LoggingCommandSessionListener();
        loggingCommandSessionListener.setFilters(listeners);
        this.sessionFactory.getCommandProcessor().addListener(loggingCommandSessionListener);
        try {
            EventAdminListener listener = new EventAdminListener(context);
            this.sessionFactory.getCommandProcessor().addListener(listener);
            this.eventAdminListener = listener;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.sessionFactory.register(new ManagerImpl(this.sessionFactory, this.sessionFactory));
        this.sessionFactoryRegistration = context.registerService(SessionFactory.class.getName(), (Object)this.sessionFactory, null);
        this.actionExtender = new CommandExtender(this.sessionFactory);
        this.actionExtender.start(context);
        if (Boolean.parseBoolean(context.getProperty(START_CONSOLE))) {
            this.terminalFactory = new TerminalFactory();
            this.localConsoleManager = new LocalConsoleManager(context, this.terminalFactory, this.sessionFactory);
            this.localConsoleManager.start();
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.filterTracker.close();
        this.sessionFactoryRegistration.unregister();
        if (this.localConsoleManager != null) {
            this.localConsoleManager.stop();
            this.terminalFactory.destroy();
        }
        this.sessionFactory.stop();
        this.actionExtender.stop(context);
        this.threadIO.stop();
        if (this.eventAdminListener != null) {
            this.eventAdminListener.close();
        }
    }
}

