/*
 * Decompiled with CFR 0.152.
 */
package com.yrashk.etcetera;

import com.yrashk.etcetera.ConfigBackend;
import com.yrashk.etcetera.ConfigBackendFactory;
import com.yrashk.etcetera.ConfigFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(immediate=true, scope=ServiceScope.SINGLETON)
public class ConfigBackendProvisioner {
    private static final String KARAF_ETC = System.getProperty("karaf.etc");
    private static final String ETCETERA_PROPERTIES = KARAF_ETC + File.separatorChar + "etcetera.properties";
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    protected List<ConfigBackendFactory> factories;
    private Set<ServiceRegistration<ConfigBackend>> registrations = new HashSet<ServiceRegistration<ConfigBackend>>();

    @Activate
    protected void activate(ComponentContext context) {
        File propertiesFile = new File(ETCETERA_PROPERTIES);
        Properties props = new Properties();
        props.put("backends", "etc");
        props.put("etc.service", "file");
        props.put("etc.path", KARAF_ETC);
        if (propertiesFile.exists()) {
            try {
                Map<String, String> cfg = ConfigFileReader.read(propertiesFile.toString() + ".cfg", new FileInputStream(propertiesFile), context.getBundleContext());
                for (Map.Entry entry : cfg.entrySet()) {
                    props.put(entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(ETCETERA_PROPERTIES + " can't be read");
            }
        }
        List backends = Arrays.stream(props.getProperty("backends").split(",")).map(String::trim).collect(Collectors.toList());
        for (String string : backends) {
            String service = props.getProperty(string + ".service");
            String prefix = string + ".";
            Map<String, Object> properties = props.keySet().stream().filter(key -> key instanceof String && ((String)key).startsWith(prefix)).collect(Collectors.toMap(key -> ((String)key).substring(prefix.length()), key -> props.getProperty((String)key)));
            properties.put("name", string);
            Optional<ServiceReference<ConfigBackendFactory>> maybeBackendFactory = this.getBackendFactory(context, service);
            if (!maybeBackendFactory.isPresent()) continue;
            properties.put("order", this.registrations.size());
            ServiceReference<ConfigBackendFactory> reference = maybeBackendFactory.get();
            ConfigBackendFactory factory = (ConfigBackendFactory)context.getBundleContext().getService(reference);
            ConfigBackend backendInstance = factory.build(properties);
            context.getBundleContext().ungetService(reference);
            ServiceRegistration registration = context.getBundleContext().registerService(ConfigBackend.class, (Object)backendInstance, new Hashtable<String, Object>(properties));
            this.registrations.add((ServiceRegistration<ConfigBackend>)registration);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.registrations.forEach(ServiceRegistration::unregister);
        this.registrations.clear();
    }

    private Optional<ServiceReference<ConfigBackendFactory>> getBackendFactory(ComponentContext context, String service) {
        Collection serviceReferences = null;
        String filter = "(type=" + service + ")";
        try {
            serviceReferences = context.getBundleContext().getServiceReferences(ConfigBackendFactory.class, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Invalid filter syntax: " + filter);
        }
        if (serviceReferences.isEmpty()) {
            return Optional.empty();
        }
        if (serviceReferences.size() > 1) {
            throw new RuntimeException("Multiple ConfigBackendFactory services found for " + service);
        }
        return serviceReferences.stream().findFirst();
    }
}

