/*
 * Decompiled with CFR 0.152.
 */
package com.yrashk.etcetera;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.BundleContext;

public class ConfigFileReader {
    private final String name;
    private final InputStream inputStream;
    private final BundleContext bundleContext;

    private ConfigFileReader(String name, InputStream inputStream, BundleContext bundleContext) {
        this.name = name;
        this.inputStream = new BufferedInputStream(inputStream);
        this.bundleContext = bundleContext;
    }

    private Map<String, String> read() throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        if (this.name.endsWith(".cfg")) {
            Properties p = new Properties();
            this.inputStream.mark(1);
            boolean isXml = this.inputStream.read() == 60;
            this.inputStream.reset();
            if (isXml) {
                p.loadFromXML(this.inputStream);
            } else {
                p.load(this.inputStream);
            }
            p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> config.put(key.toString(), value.toString())));
            InterpolationHelper.performSubstitution(config, (BundleContext)this.bundleContext);
        }
        this.inputStream.close();
        return config;
    }

    public static Map<String, String> read(String name, InputStream inputStream, BundleContext bundleContext) throws IOException {
        return new ConfigFileReader(name, inputStream, bundleContext).read();
    }

    public static Map<String, String> read(String name, InputStream inputStream) throws IOException {
        return new ConfigFileReader(name, inputStream, null).read();
    }
}

