/*
 * Decompiled with CFR 0.152.
 */
package com.yrashk.etcetera;

import com.yrashk.etcetera.ConfigBackend;
import com.yrashk.etcetera.ConfigFileReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(immediate=true, scope=ServiceScope.SINGLETON)
public class ConfigScanner {
    private List<ConfigBackend> backends = new ArrayList<ConfigBackend>();
    @Reference
    private ConfigurationAdmin configurationAdmin;

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindConfigBackend(ConfigBackend backend) {
        this.backends.add(backend);
        this.backends.sort((x, y) -> new Integer(x.getOrder()).compareTo(y.getOrder()));
    }

    protected void unbindConfigBackend(ConfigBackend backend) {
        this.backends.remove(backend);
    }

    @Activate
    protected void activate(ComponentContext context) throws IOException {
        for (ConfigBackend backend : this.backends) {
            for (String name : backend.getFilenames()) {
                InputStream fileInputStream;
                Map<String, String> config = ConfigFileReader.read(name, fileInputStream = backend.getFileInputStream(name), context.getBundleContext());
                if (config.size() <= 0) continue;
                String factory = this.getFactory(name);
                String pid = this.getPid(name);
                Configuration configuration = factory == null ? this.configurationAdmin.getConfiguration(pid, null) : this.configurationAdmin.createFactoryConfiguration(pid, null);
                Hashtable properties = configuration.getProperties();
                if (properties == null) {
                    properties = new Hashtable();
                }
                config.forEach(properties::put);
                configuration.update(properties);
            }
        }
    }

    private String getPid(String name) {
        String pid = new File(name).getName();
        if (pid.indexOf(".") > 0) {
            pid = pid.substring(0, pid.lastIndexOf("."));
        }
        if (pid.indexOf("-") > 0) {
            pid = pid.substring(0, pid.indexOf("-"));
        }
        return pid;
    }

    private String getFactory(String name) {
        String pid = new File(name).getName();
        if (pid.indexOf(".") > 0) {
            pid = pid.substring(0, pid.lastIndexOf("."));
        }
        if (pid.indexOf("-") > 0) {
            return pid.substring(pid.indexOf("-") + 1);
        }
        return null;
    }
}

