/*
 * Decompiled with CFR 0.152.
 */
package com.yrashk.etcetera;

import com.yrashk.etcetera.ConfigBackend;
import com.yrashk.etcetera.ConfigFileReader;
import com.yrashk.etcetera.SavePolicy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(immediate=true, scope=ServiceScope.SINGLETON)
public class ConfigWriter
implements ConfigurationListener {
    private BundleContext context;
    private List<BackendPolicy> backends = new ArrayList<BackendPolicy>();
    @Reference
    private ConfigurationAdmin configurationAdmin;

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindConfigBackend(ServiceReference<ConfigBackend> reference, ConfigBackend backend) {
        SavePolicy savePolicy = SavePolicy.NONE;
        if (reference.getProperty("save") != null) {
            savePolicy = SavePolicy.valueOf((String)reference.getProperty("save"));
        }
        this.backends.add(new BackendPolicy(backend, savePolicy));
        this.backends.sort((x, y) -> new Integer(x.getBackend().getOrder()).compareTo(y.getBackend().getOrder()));
    }

    protected void unbindConfigBackend(ServiceReference<ConfigBackend> reference, ConfigBackend backend) {
        this.backends.remove(backend);
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context.getBundleContext();
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() != 1) {
            return;
        }
        for (BackendPolicy backendPolicy : this.backends) {
            SavePolicy policy = backendPolicy.getPolicy();
            if (policy == SavePolicy.NONE) continue;
            ConfigBackend backend = backendPolicy.getBackend();
            String filename = event.getPid() + ".cfg";
            try {
                Map<String, String> original;
                Object e2;
                Serializable props;
                InputStream fileInputStream;
                boolean isXML;
                Configuration config = this.configurationAdmin.getConfiguration(event.getPid(), event.getFactoryPid());
                Dictionary dict = config.getProperties();
                boolean fileExists = backend.getFilenames().stream().anyMatch(name -> name.contentEquals(filename));
                if (policy == SavePolicy.FILES && fileExists || policy == SavePolicy.ALL) {
                    isXML = false;
                    if (fileExists) {
                        fileInputStream = backend.getFileInputStream(filename);
                        Throwable throwable = null;
                        try {
                            isXML = fileInputStream.read() == 60;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fileInputStream != null) {
                                if (throwable != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    fileInputStream.close();
                                }
                            }
                        }
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    props = new Properties();
                    e2 = dict.keys();
                    while (e2.hasMoreElements()) {
                        String key = e2.nextElement().toString();
                        String value = dict.get(key).toString();
                        if (key.contentEquals("service.pid") || key.contentEquals("service.factoryPid")) continue;
                        ((Properties)props).put(key, value);
                    }
                    if (isXML) {
                        ((Properties)props).storeToXML(bos, "");
                    } else {
                        ((Properties)props).store(bos, "");
                    }
                    backend.save(filename, bos.toString());
                }
                if (policy != SavePolicy.PROPERTIES || !fileExists) continue;
                fileInputStream = backend.getFileInputStream(filename);
                props = null;
                try {
                    isXML = fileInputStream.read() == 60;
                }
                catch (Throwable e2) {
                    props = e2;
                    throw e2;
                }
                finally {
                    if (fileInputStream != null) {
                        if (props != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable e2) {
                                ((Throwable)props).addSuppressed(e2);
                            }
                        } else {
                            fileInputStream.close();
                        }
                    }
                }
                InputStream fileInputStream2 = backend.getFileInputStream(filename);
                e2 = null;
                try {
                    original = ConfigFileReader.read(filename, fileInputStream2, this.context);
                }
                catch (Throwable throwable) {
                    e2 = throwable;
                    throw throwable;
                }
                finally {
                    if (fileInputStream2 != null) {
                        if (e2 != null) {
                            try {
                                fileInputStream2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)e2).addSuppressed(throwable);
                            }
                        } else {
                            fileInputStream2.close();
                        }
                    }
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Properties props2 = new Properties();
                for (Map.Entry<String, String> entry : original.entrySet()) {
                    String key = entry.getKey();
                    if (key.contentEquals("service.pid") || key.contentEquals("service.factoryPid")) continue;
                    Object newValue = dict.get(key);
                    if (newValue == null) {
                        props2.put(key, entry.getValue());
                        continue;
                    }
                    props2.put(key, newValue);
                }
                if (isXML) {
                    props2.storeToXML(bos, "");
                } else {
                    props2.store(bos, "");
                }
                backend.save(filename, bos.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class BackendPolicy {
        private final ConfigBackend backend;
        private final SavePolicy policy;

        private BackendPolicy(ConfigBackend backend, SavePolicy policy) {
            this.backend = backend;
            this.policy = policy;
        }

        public ConfigBackend getBackend() {
            return this.backend;
        }

        public SavePolicy getPolicy() {
            return this.policy;
        }
    }
}

