/*
 * Decompiled with CFR 0.152.
 */
package com.yrashk.etcetera;

import com.yrashk.etcetera.ConfigBackend;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class FileConfigBackend
implements ConfigBackend {
    private String path;
    private String name;
    private int order;

    @Override
    public Collection<String> getFilenames() {
        try {
            return Files.walk(new File(this.path).toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).map(file -> file.toString().substring(this.path.length() + 1)).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public InputStream getFileInputStream(String name) throws IOException {
        return new FileInputStream(this.getFilename(name));
    }

    @Override
    public void save(String name, String content) throws IOException {
        FileWriter fileWriter = new FileWriter(this.getFilename(name));
        fileWriter.write(content);
        fileWriter.close();
    }

    private String getFilename(String name) {
        return this.path + File.separatorChar + name;
    }

    public FileConfigBackend(String path, String name, int order) {
        this.path = path;
        this.name = name;
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "FileConfigBackend{name=" + this.name + ", path=" + this.path + "}";
    }
}

