/*
 * Decompiled with CFR 0.152.
 */
package com.yrashk.etcetera;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.yrashk.etcetera.ConfigBackend;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class S3ConfigBackend
implements ConfigBackend {
    private final String bucket;
    private final String endpoint;
    private final String name;
    private final int order;
    private final AmazonS3Client client;

    public S3ConfigBackend(String bucket, String endpoint, String name, int order) {
        this.bucket = bucket;
        this.endpoint = endpoint;
        this.name = name;
        this.order = order;
        this.client = new AmazonS3Client((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        if (endpoint != null) {
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public Collection<String> getFilenames() {
        ListObjectsV2Result listing;
        ArrayList<String> names = new ArrayList<String>();
        ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(this.bucket);
        do {
            listing = this.client.listObjectsV2(req);
            names.addAll(listing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList()));
        } while (listing.isTruncated());
        return names;
    }

    @Override
    public InputStream getFileInputStream(String name) throws IOException {
        return this.client.getObject(this.bucket, name).getObjectContent();
    }

    @Override
    public void save(String name, String content) throws IOException {
        this.client.putObject(this.bucket, name, content);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

