/*
 * Decompiled with CFR 0.152.
 */
package com.yrashk.etcetera.commands;

import com.yrashk.etcetera.ConfigBackend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Command(scope="etcetera", name="backends", description="List configuration backends")
@Service
public class BackendListCommand
implements Action {
    public static final List<String> SYSTEM_KEYS = Arrays.asList("order", "name", "service", "save", "objectClass", "service.bundleid", "service.id", "service.scope");

    public Object execute() throws Exception {
        BundleContext context = FrameworkUtil.getBundle(BackendListCommand.class).getBundleContext();
        ArrayList references = new ArrayList(context.getServiceReferences(ConfigBackend.class, "(order=*)"));
        ShellTable table = new ShellTable();
        table.column("Order").alignRight();
        table.column("Name").alignLeft();
        table.column("Service").alignLeft();
        table.column("Configuration").alignLeft();
        table.column("Save Policy").alignLeft();
        table.emptyTableText("No backends available");
        references.sort((x, y) -> ((Integer)x.getProperty("order")).compareTo((Integer)y.getProperty("order")));
        for (ServiceReference reference : references) {
            ConfigBackend service = (ConfigBackend)context.getService(reference);
            int order = (Integer)reference.getProperty("order");
            String name = (String)reference.getProperty("name");
            String svc = (String)reference.getProperty("service");
            String savePolicy = (String)reference.getProperty("save");
            if (savePolicy == null) {
                savePolicy = "NONE";
            }
            ArrayList<String> cfg = new ArrayList<String>();
            for (String key : reference.getPropertyKeys()) {
                if (SYSTEM_KEYS.contains(key)) continue;
                cfg.add(key + "=" + reference.getProperty(key));
            }
            table.addRow().addContent(new Object[]{order, name, svc, cfg.stream().collect(Collectors.joining(", ")), savePolicy});
            context.ungetService(reference);
        }
        table.print(System.out);
        return null;
    }
}

