/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetMethodRequestMarshaller
implements Marshaller<Request<GetMethodRequest>, GetMethodRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetMethodRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetMethodRequest> marshall(GetMethodRequest getMethodRequest) {
        if (getMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetMethodRequest> request = new DefaultRequest<GetMethodRequest>(getMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getMethodRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getMethodRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", getMethodRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getMethodRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", getMethodRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getMethodRequest.getHttpMethod()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

