/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.ListChangeSetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListChangeSetsRequestMarshaller
implements Marshaller<Request<ListChangeSetsRequest>, ListChangeSetsRequest> {
    @Override
    public Request<ListChangeSetsRequest> marshall(ListChangeSetsRequest listChangeSetsRequest) {
        if (listChangeSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListChangeSetsRequest> request = new DefaultRequest<ListChangeSetsRequest>(listChangeSetsRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListChangeSets");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listChangeSetsRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(listChangeSetsRequest.getStackName()));
        }
        if (listChangeSetsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listChangeSetsRequest.getNextToken()));
        }
        return request;
    }
}

