/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.ListIpRoutesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListIpRoutesRequestMarshaller
implements Marshaller<Request<ListIpRoutesRequest>, ListIpRoutesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListIpRoutesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListIpRoutesRequest> marshall(ListIpRoutesRequest listIpRoutesRequest) {
        if (listIpRoutesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListIpRoutesRequest> request = new DefaultRequest<ListIpRoutesRequest>(listIpRoutesRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.ListIpRoutes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listIpRoutesRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(listIpRoutesRequest.getDirectoryId());
            }
            if (listIpRoutesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listIpRoutesRequest.getNextToken());
            }
            if (listIpRoutesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listIpRoutesRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

