/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardMethodReflects;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardParameterTypes;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SdkInternalApi
final class StandardBeanProperties {
    private static final ConcurrentMap<Class<?>, Beans<?>> CACHE = new ConcurrentHashMap();

    StandardBeanProperties() {
    }

    static final <T> Beans<T> of(Class<T> clazz) {
        if (!CACHE.containsKey(clazz)) {
            Beans<T> beans = StandardBeanProperties.of(clazz, false);
            if (!beans.annotations().typed()) {
                return beans;
            }
            CACHE.putIfAbsent(clazz, beans);
        }
        return (Beans)CACHE.get(clazz);
    }

    static final <T> Beans<T> of(Class<T> clazz, boolean inherited) {
        return new Beans(StandardAnnotationMaps.of(clazz), StandardBeanProperties.map(clazz, inherited));
    }

    private static final <T, V> Map<String, Bean<T, V>> map(Class<T> clazz, boolean inherited) {
        LinkedHashMap<String, Bean<T, V>> map = new LinkedHashMap<String, Bean<T, V>>();
        for (Method m : clazz.getMethods()) {
            StandardAnnotationMaps.FieldMap annotations;
            if (!StandardBeanProperties.isGetter(m) || !inherited && m.getDeclaringClass() != clazz && !StandardAnnotationMaps.of(m.getDeclaringClass()).typed() || (annotations = StandardAnnotationMaps.of(clazz, m)).ignored()) continue;
            StandardBeanProperties.flatten(new Bean(annotations, m), map);
        }
        return map;
    }

    private static final <T, V> void flatten(Bean<T, V> bean, Map<String, Bean<T, V>> map) {
        if (bean.annotations().flattened() == null) {
            if (map.put(bean.attributeName(), bean) != null) {
                throw new DynamoDBMappingException(bean.id().err("duplicate attribute name", new Object[0]));
            }
            return;
        }
        Bean<T, V> declaring = bean;
        Map<String, String> attributes = bean.annotations().attributes();
        for (Method m : declaring.targetType().getMethods()) {
            if (!StandardBeanProperties.isGetter(m)) continue;
            StandardAnnotationMaps.FieldMap annotations = StandardAnnotationMaps.of(declaring.targetType(), m);
            String name = annotations.attributeName();
            if (annotations.ignored() || (name = attributes.remove(name)) == null) continue;
            StandardBeanProperties.flatten(new Bean(annotations, declaring, m, name), map);
        }
        if (!attributes.isEmpty()) {
            throw new DynamoDBMappingException(bean.id().err("contains unknown flattened attribute(s): " + attributes, new Object[0]));
        }
    }

    private static final boolean isGetter(Method method) {
        if (!method.getName().matches("^(get|is).+")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        if (method.isSynthetic()) {
            return false;
        }
        return method.getDeclaringClass() != Object.class;
    }

    static final class Bean<T, V>
    extends DynamoDBMapperFieldModel.Properties.Immutable<T, V> {
        private final StandardAnnotationMaps.FieldMap<T, V> annotations;
        private final DynamoDBMapperFieldModel.Reflect<T, V> reflect;
        private final StandardParameterTypes.ParamType<V> type;
        private final Method getter;

        private Bean(StandardAnnotationMaps.FieldMap<T, V> annotations, Bean<T, T> declaring, Method getter, String name) {
            super(new DynamoDBMapperFieldModel.Properties.Buildable(annotations).withId(new DynamoDBMapperFieldModel.Id(declaring.id(), name)).withAttributeName(name));
            this.reflect = StandardMethodReflects.of(getter, declaring.reflect(), declaring.targetType());
            this.type = StandardParameterTypes.of(getter.getGenericReturnType(), new Type[0]);
            this.annotations = annotations;
            this.getter = getter;
        }

        private Bean(StandardAnnotationMaps.FieldMap<T, V> annotations, Method getter) {
            super(new DynamoDBMapperFieldModel.Properties.Buildable(annotations).withId(new DynamoDBMapperFieldModel.Id<T>(annotations.id(), annotations.attributeName())));
            this.reflect = StandardMethodReflects.of(getter);
            this.type = StandardParameterTypes.of(getter.getGenericReturnType(), new Type[0]);
            this.annotations = annotations;
            this.getter = getter;
        }

        final StandardAnnotationMaps.FieldMap<T, V> annotations() {
            return this.annotations;
        }

        final DynamoDBMapperFieldModel.Reflect<T, V> reflect() {
            return this.reflect;
        }

        final StandardParameterTypes.ParamType<V> type() {
            return this.type;
        }

        @Deprecated
        final Method getter() {
            return this.getter;
        }
    }

    static final class Beans<T>
    extends DynamoDBMapperTableModel.Properties.Immutable<T> {
        private final Map<String, Bean<T, Object>> map;
        private final StandardAnnotationMaps.TableMap<T> annotations;

        private Beans(StandardAnnotationMaps.TableMap<T> annotations, Map<String, Bean<T, Object>> map) {
            super(annotations);
            this.map = Collections.unmodifiableMap(map);
            this.annotations = annotations;
        }

        final StandardAnnotationMaps.TableMap<T> annotations() {
            return this.annotations;
        }

        final Map<String, Bean<T, Object>> map() {
            return this.map;
        }
    }
}

