/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseAsync;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseClient;
import com.amazonaws.services.kinesisfirehose.model.CreateDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.CreateDeliveryStreamResult;
import com.amazonaws.services.kinesisfirehose.model.DeleteDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.DeleteDeliveryStreamResult;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamResult;
import com.amazonaws.services.kinesisfirehose.model.ListDeliveryStreamsRequest;
import com.amazonaws.services.kinesisfirehose.model.ListDeliveryStreamsResult;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchResult;
import com.amazonaws.services.kinesisfirehose.model.PutRecordRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordResult;
import com.amazonaws.services.kinesisfirehose.model.UpdateDestinationRequest;
import com.amazonaws.services.kinesisfirehose.model.UpdateDestinationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisFirehoseAsyncClient
extends AmazonKinesisFirehoseClient
implements AmazonKinesisFirehoseAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonKinesisFirehoseAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonKinesisFirehoseAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonKinesisFirehoseAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonKinesisFirehoseAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonKinesisFirehoseAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonKinesisFirehoseAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonKinesisFirehoseAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDeliveryStreamResult> createDeliveryStreamAsync(CreateDeliveryStreamRequest request) {
        return this.createDeliveryStreamAsync(request, null);
    }

    @Override
    public Future<CreateDeliveryStreamResult> createDeliveryStreamAsync(final CreateDeliveryStreamRequest request, final AsyncHandler<CreateDeliveryStreamRequest, CreateDeliveryStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDeliveryStreamResult>(){

            @Override
            public CreateDeliveryStreamResult call() throws Exception {
                CreateDeliveryStreamResult result;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.createDeliveryStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDeliveryStreamResult> deleteDeliveryStreamAsync(DeleteDeliveryStreamRequest request) {
        return this.deleteDeliveryStreamAsync(request, null);
    }

    @Override
    public Future<DeleteDeliveryStreamResult> deleteDeliveryStreamAsync(final DeleteDeliveryStreamRequest request, final AsyncHandler<DeleteDeliveryStreamRequest, DeleteDeliveryStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDeliveryStreamResult>(){

            @Override
            public DeleteDeliveryStreamResult call() throws Exception {
                DeleteDeliveryStreamResult result;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.deleteDeliveryStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryStreamResult> describeDeliveryStreamAsync(DescribeDeliveryStreamRequest request) {
        return this.describeDeliveryStreamAsync(request, null);
    }

    @Override
    public Future<DescribeDeliveryStreamResult> describeDeliveryStreamAsync(final DescribeDeliveryStreamRequest request, final AsyncHandler<DescribeDeliveryStreamRequest, DescribeDeliveryStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDeliveryStreamResult>(){

            @Override
            public DescribeDeliveryStreamResult call() throws Exception {
                DescribeDeliveryStreamResult result;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.describeDeliveryStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeliveryStreamsResult> listDeliveryStreamsAsync(ListDeliveryStreamsRequest request) {
        return this.listDeliveryStreamsAsync(request, null);
    }

    @Override
    public Future<ListDeliveryStreamsResult> listDeliveryStreamsAsync(final ListDeliveryStreamsRequest request, final AsyncHandler<ListDeliveryStreamsRequest, ListDeliveryStreamsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDeliveryStreamsResult>(){

            @Override
            public ListDeliveryStreamsResult call() throws Exception {
                ListDeliveryStreamsResult result;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.listDeliveryStreams(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(PutRecordRequest request) {
        return this.putRecordAsync(request, null);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(final PutRecordRequest request, final AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutRecordResult>(){

            @Override
            public PutRecordResult call() throws Exception {
                PutRecordResult result;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.putRecord(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecordBatchResult> putRecordBatchAsync(PutRecordBatchRequest request) {
        return this.putRecordBatchAsync(request, null);
    }

    @Override
    public Future<PutRecordBatchResult> putRecordBatchAsync(final PutRecordBatchRequest request, final AsyncHandler<PutRecordBatchRequest, PutRecordBatchResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutRecordBatchResult>(){

            @Override
            public PutRecordBatchResult call() throws Exception {
                PutRecordBatchResult result;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.putRecordBatch(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request) {
        return this.updateDestinationAsync(request, null);
    }

    @Override
    public Future<UpdateDestinationResult> updateDestinationAsync(final UpdateDestinationRequest request, final AsyncHandler<UpdateDestinationRequest, UpdateDestinationResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateDestinationResult>(){

            @Override
            public UpdateDestinationResult call() throws Exception {
                UpdateDestinationResult result;
                try {
                    result = AmazonKinesisFirehoseAsyncClient.this.updateDestination(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

