/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListVersionsByFunctionRequestMarshaller
implements Marshaller<Request<ListVersionsByFunctionRequest>, ListVersionsByFunctionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListVersionsByFunctionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListVersionsByFunctionRequest> marshall(ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        if (listVersionsByFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListVersionsByFunctionRequest> request = new DefaultRequest<ListVersionsByFunctionRequest>(listVersionsByFunctionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/versions";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", listVersionsByFunctionRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listVersionsByFunctionRequest.getFunctionName()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listVersionsByFunctionRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listVersionsByFunctionRequest.getMarker()));
        }
        if (listVersionsByFunctionRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listVersionsByFunctionRequest.getMaxItems()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

