/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import com.yscope.clp.compressorfrontend.ByteSegment;
import com.yscope.clp.compressorfrontend.ByteSegments;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public abstract class AbstractClpEncodedSubquery {
    private static final byte VAR_SCHEMAS_V2_DICT_VAR_PLACEHOLDER = 18;
    private final byte[] query;
    private final byte[] logtypeQuery;
    private final boolean logtypeQueryContainsWildcards;
    private final int[] dictVarBounds;
    private final byte[] wildcardVarPlaceholders;
    private final int[] wildcardVarBounds;

    public AbstractClpEncodedSubquery(byte[] query, byte[] logtypeQuery, boolean logtypeQueryContainsWildcards, int[] dictVarBounds, byte[] wildcardVarPlaceholders, int[] wildcardVarBounds) {
        this.query = query;
        this.logtypeQuery = logtypeQuery;
        this.logtypeQueryContainsWildcards = logtypeQueryContainsWildcards;
        this.dictVarBounds = dictVarBounds;
        this.wildcardVarPlaceholders = wildcardVarPlaceholders;
        this.wildcardVarBounds = wildcardVarBounds;
    }

    public String getLogtypeQueryAsString() {
        return new String(this.logtypeQuery, StandardCharsets.ISO_8859_1);
    }

    public boolean logtypeQueryContainsWildcards() {
        return this.logtypeQueryContainsWildcards;
    }

    public ByteSegments getDictVars() {
        return new ByteSegments(this.query, this.dictVarBounds);
    }

    public int getNumDictVars() {
        return this.dictVarBounds.length / 2;
    }

    public DictionaryVariableWildcardQueries getDictVarWildcardQueries() {
        return new DictionaryVariableWildcardQueries();
    }

    public int getNumDictVarWildcardQueries() {
        int count = 0;
        for (VariableWildcardQuery ignored : this.getDictVarWildcardQueries()) {
            ++count;
        }
        return count;
    }

    public EncodedVariableWildcardQueries getEncodedVarWildcardQueries() {
        return new EncodedVariableWildcardQueries();
    }

    public int getNumEncodedVarWildcardQueries() {
        int count = 0;
        for (VariableWildcardQuery ignored : this.getEncodedVarWildcardQueries()) {
            ++count;
        }
        return count;
    }

    protected boolean containsVariables() {
        return this.dictVarBounds.length > 0 || this.wildcardVarPlaceholders.length > 0;
    }

    public class VariableWildcardQuery {
        private final byte type;
        private final ByteSegment query;

        public VariableWildcardQuery(byte type, ByteSegment query) {
            this.type = type;
            this.query = query;
        }

        public byte getType() {
            return this.type;
        }

        public ByteSegment getQuery() {
            return this.query;
        }
    }

    public abstract class VariableWildcardQueries
    implements Iterable<VariableWildcardQuery> {
        public Iterator iterator() {
            return new Iterator();
        }

        public abstract boolean isRelevantType(byte var1);

        public class Iterator
        implements java.util.Iterator<VariableWildcardQuery> {
            private int substringBoundsIdx = 0;
            private int varIdx = 0;

            @Override
            public boolean hasNext() {
                while (this.varIdx < AbstractClpEncodedSubquery.this.wildcardVarPlaceholders.length && !VariableWildcardQueries.this.isRelevantType(AbstractClpEncodedSubquery.this.wildcardVarPlaceholders[this.varIdx])) {
                    ++this.varIdx;
                    this.substringBoundsIdx += 2;
                }
                return AbstractClpEncodedSubquery.this.wildcardVarPlaceholders.length != this.varIdx;
            }

            @Override
            public VariableWildcardQuery next() {
                int beginIdx = AbstractClpEncodedSubquery.this.wildcardVarBounds[this.substringBoundsIdx++];
                int endIdx = AbstractClpEncodedSubquery.this.wildcardVarBounds[this.substringBoundsIdx++];
                return new VariableWildcardQuery(AbstractClpEncodedSubquery.this.wildcardVarPlaceholders[this.varIdx++], new ByteSegment(AbstractClpEncodedSubquery.this.query, beginIdx, endIdx));
            }
        }
    }

    public class EncodedVariableWildcardQueries
    extends VariableWildcardQueries {
        @Override
        public boolean isRelevantType(byte type) {
            return 18 != type;
        }
    }

    public class DictionaryVariableWildcardQueries
    extends VariableWildcardQueries {
        @Override
        public boolean isRelevantType(byte type) {
            return 18 == type;
        }
    }
}

