/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import java.nio.charset.StandardCharsets;
import java.util.stream.LongStream;

public class EncodedMessage {
    public byte[] logtype;
    public long[] encodedVars;
    public int[] dictionaryVarBounds;
    private byte[] message;

    public void setMessage(byte[] message) {
        this.message = message;
        this.logtype = null;
        this.encodedVars = null;
        this.dictionaryVarBounds = null;
    }

    public String getLogTypeAsString() {
        if (null == this.logtype) {
            return null;
        }
        return new String(this.logtype, StandardCharsets.ISO_8859_1);
    }

    public String[] getDictionaryVarsAsStrings() {
        if (null == this.dictionaryVarBounds) {
            return null;
        }
        int numVars = this.dictionaryVarBounds.length / 2;
        String[] dictVars = new String[numVars];
        int j = 0;
        for (int i = 0; i < dictVars.length; ++i) {
            int beginOffset = this.dictionaryVarBounds[j++];
            int endOffset = this.dictionaryVarBounds[j++];
            dictVars[i] = new String(this.message, beginOffset, endOffset - beginOffset, StandardCharsets.ISO_8859_1);
        }
        return dictVars;
    }

    public Long[] getEncodedVarsAsBoxedLongs() {
        if (null == this.encodedVars) {
            return null;
        }
        return (Long[])LongStream.of(this.encodedVars).boxed().toArray(Long[]::new);
    }
}

