/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import com.yscope.clp.compressorfrontend.NativeLibraryLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MessageDecoder {
    public MessageDecoder(@NotNull String variablesSchemaVersion, @NotNull String variableEncodingMethodsVersion) throws UnsupportedOperationException {
        Objects.requireNonNull(variablesSchemaVersion);
        Objects.requireNonNull(variableEncodingMethodsVersion);
        byte[] schemaVersionBytes = variablesSchemaVersion.getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodingMethodsVersionBytes = variableEncodingMethodsVersion.getBytes(StandardCharsets.ISO_8859_1);
        this.setVariableHandlingRuleVersions(schemaVersionBytes, schemaVersionBytes.length, encodingMethodsVersionBytes, encodingMethodsVersionBytes.length);
    }

    private native void setVariableHandlingRuleVersions(byte[] var1, int var2, byte[] var3, int var4) throws UnsupportedOperationException;

    public String decodeMessage(@NotNull String logtype, String[] dictionaryVars, long[] encodedVars) throws IOException {
        Objects.requireNonNull(logtype);
        int[] dictionaryVarEndOffsets = null;
        byte[] allDictionaryVars = null;
        if (null != dictionaryVars) {
            dictionaryVarEndOffsets = new int[dictionaryVars.length];
            ByteArrayOutputStream dictionaryVarsOutputStream = new ByteArrayOutputStream();
            int lastDictionaryVarEndOffset = 0;
            for (int i = 0; i < dictionaryVars.length; ++i) {
                byte[] dictionaryVarBytes = dictionaryVars[i].getBytes(StandardCharsets.UTF_8);
                dictionaryVarsOutputStream.write(dictionaryVarBytes);
                dictionaryVarEndOffsets[i] = lastDictionaryVarEndOffset += dictionaryVarBytes.length;
            }
            allDictionaryVars = dictionaryVarsOutputStream.toByteArray();
        }
        byte[] logtypeBytes = logtype.getBytes(StandardCharsets.ISO_8859_1);
        byte[] messageBytes = this.decodeMessageNative(logtypeBytes, logtypeBytes.length, allDictionaryVars, null == allDictionaryVars ? 0 : allDictionaryVars.length, dictionaryVarEndOffsets, null == dictionaryVarEndOffsets ? 0 : dictionaryVarEndOffsets.length, encodedVars, null == encodedVars ? 0 : encodedVars.length);
        return new String(messageBytes, StandardCharsets.UTF_8);
    }

    private native byte[] decodeMessageNative(byte[] var1, int var2, byte[] var3, int var4, int[] var5, int var6, long[] var7, int var8) throws IOException;

    public boolean wildcardQueryMatchesAnyIntVar(@NotNull String wildcardQuery, @NotNull String logtype, long[] encodedVars) throws IOException {
        Objects.requireNonNull(wildcardQuery);
        Objects.requireNonNull(logtype);
        byte[] wildcardQueryBytes = wildcardQuery.getBytes(StandardCharsets.ISO_8859_1);
        byte[] logtypeBytes = logtype.getBytes(StandardCharsets.ISO_8859_1);
        return this.wildcardQueryMatchesAnyIntVarNative(wildcardQueryBytes, wildcardQueryBytes.length, logtypeBytes, logtypeBytes.length, encodedVars, null == encodedVars ? 0 : encodedVars.length);
    }

    private native boolean wildcardQueryMatchesAnyIntVarNative(byte[] var1, int var2, byte[] var3, int var4, long[] var5, int var6) throws IOException;

    public boolean wildcardQueryMatchesAnyFloatVar(@NotNull String wildcardQuery, @NotNull String logtype, long[] encodedVars) throws IOException {
        Objects.requireNonNull(wildcardQuery);
        Objects.requireNonNull(logtype);
        byte[] wildcardQueryBytes = wildcardQuery.getBytes(StandardCharsets.ISO_8859_1);
        byte[] logtypeBytes = logtype.getBytes(StandardCharsets.ISO_8859_1);
        return this.wildcardQueryMatchesAnyFloatVarNative(wildcardQueryBytes, wildcardQueryBytes.length, logtypeBytes, logtypeBytes.length, encodedVars, null == encodedVars ? 0 : encodedVars.length);
    }

    private native boolean wildcardQueryMatchesAnyFloatVarNative(byte[] var1, int var2, byte[] var3, int var4, long[] var5, int var6) throws IOException;

    public void batchEncodedVarsWildcardMatch(@NotNull byte[][] logtypes, @NotNull long[][] encodedVarArrays, @NotNull byte[] wildcardVarPlaceholders, @NotNull byte[] serializedVarWildcardQueries, @NotNull int[] varWildcardQueryEndIndexes, @NotNull int[] matchResults) throws IOException {
        Objects.requireNonNull(logtypes);
        Objects.requireNonNull(encodedVarArrays);
        Objects.requireNonNull(wildcardVarPlaceholders);
        Objects.requireNonNull(serializedVarWildcardQueries);
        Objects.requireNonNull(varWildcardQueryEndIndexes);
        Objects.requireNonNull(matchResults);
        if (logtypes.length != matchResults.length) {
            throw new IllegalArgumentException("Number of logtypes given doesn't match size of output array.");
        }
        if (encodedVarArrays.length != matchResults.length) {
            throw new IllegalArgumentException("Number of encoded variable arrays given doesn't match size of output array.");
        }
        int lastIdx = 0;
        for (int i : varWildcardQueryEndIndexes) {
            if (i < lastIdx) {
                throw new IllegalArgumentException("Invalid wildcard variable query end index: i (" + i + ") < lastIdx (" + lastIdx + ")");
            }
            if (i > serializedVarWildcardQueries.length) {
                throw new IllegalArgumentException("Invalid wildcard variable query end index: i (" + i + ") > serializedVarWildcardQueries.length (" + lastIdx + ")");
            }
            lastIdx = i;
        }
        this.batchEncodedVarsWildcardMatchNative(logtypes.length, logtypes, encodedVarArrays, wildcardVarPlaceholders, wildcardVarPlaceholders.length, serializedVarWildcardQueries, serializedVarWildcardQueries.length, varWildcardQueryEndIndexes, varWildcardQueryEndIndexes.length, matchResults);
    }

    private native void batchEncodedVarsWildcardMatchNative(int var1, byte[][] var2, long[][] var3, byte[] var4, int var5, byte[] var6, int var7, int[] var8, int var9, int[] var10) throws IOException;

    static {
        NativeLibraryLoader.load();
    }
}

