/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import com.yscope.clp.compressorfrontend.FlattenedByteArray;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.LongStream;
import org.jetbrains.annotations.NotNull;

public class EncodedMessage {
    private byte[] logtype;
    private long[] encodedVars;
    private int[] dictionaryVarBounds;
    private FlattenedByteArray flattenedDictVars;
    private byte[] message;

    public void setMessage(byte @NotNull [] message) {
        Objects.requireNonNull(message);
        this.message = message;
        this.logtype = null;
        this.encodedVars = null;
        this.dictionaryVarBounds = null;
        this.flattenedDictVars = null;
    }

    public byte[] getLogtype() {
        return this.logtype;
    }

    public String getLogTypeAsString() {
        if (null == this.logtype) {
            return null;
        }
        return new String(this.logtype, StandardCharsets.ISO_8859_1);
    }

    public String[] getDictionaryVarsAsStrings() {
        if (null == this.dictionaryVarBounds) {
            return null;
        }
        int numVars = this.dictionaryVarBounds.length / 2;
        String[] dictVars = new String[numVars];
        int j = 0;
        for (int i = 0; i < dictVars.length; ++i) {
            int beginOffset = this.dictionaryVarBounds[j++];
            int endOffset = this.dictionaryVarBounds[j++];
            dictVars[i] = new String(this.message, beginOffset, endOffset - beginOffset, StandardCharsets.ISO_8859_1);
        }
        return dictVars;
    }

    public byte[][] getDictionaryVarsAsByteArrays() {
        if (null == this.dictionaryVarBounds) {
            return null;
        }
        int numVars = this.dictionaryVarBounds.length / 2;
        byte[][] dictVars = new byte[numVars][];
        int j = 0;
        for (int i = 0; i < dictVars.length; ++i) {
            int beginOffset = this.dictionaryVarBounds[j++];
            int endOffset = this.dictionaryVarBounds[j++];
            dictVars[i] = Arrays.copyOfRange(this.message, beginOffset, endOffset);
        }
        return dictVars;
    }

    public FlattenedByteArray getDictionaryVarsAsFlattenedByteArray() {
        if (null == this.dictionaryVarBounds) {
            return null;
        }
        if (null != this.flattenedDictVars) {
            return this.flattenedDictVars;
        }
        int flattenedVarsLength = 0;
        int[] flattenedVarsEndOffsets = new int[this.dictionaryVarBounds.length / 2];
        int varBoundsIdx = 0;
        int endOffsetsIdx = 0;
        while (varBoundsIdx < this.dictionaryVarBounds.length) {
            int varBeginOffset = this.dictionaryVarBounds[varBoundsIdx++];
            int varEndOffset = this.dictionaryVarBounds[varBoundsIdx++];
            flattenedVarsEndOffsets[endOffsetsIdx] = flattenedVarsLength += varEndOffset - varBeginOffset;
            ++endOffsetsIdx;
        }
        byte[] flattenedVars = new byte[flattenedVarsLength];
        int varBoundsIdx2 = 0;
        int flattenedVarsOffset = 0;
        while (varBoundsIdx2 < this.dictionaryVarBounds.length) {
            int varBeginOffset = this.dictionaryVarBounds[varBoundsIdx2++];
            int varEndOffset = this.dictionaryVarBounds[varBoundsIdx2++];
            int varLength = varEndOffset - varBeginOffset;
            System.arraycopy(this.message, varBeginOffset, flattenedVars, flattenedVarsOffset, varLength);
            flattenedVarsOffset += varLength;
        }
        this.flattenedDictVars = new FlattenedByteArray(flattenedVars, flattenedVarsEndOffsets);
        return this.flattenedDictVars;
    }

    public long[] getEncodedVars() {
        return this.encodedVars;
    }

    public Long[] getEncodedVarsAsBoxedLongs() {
        if (null == this.encodedVars) {
            return null;
        }
        return (Long[])LongStream.of(this.encodedVars).boxed().toArray(Long[]::new);
    }

    public byte[] getMessage() {
        return this.message;
    }
}

