/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation.resolver;

import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.AttestationResolver;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;

public final class CompositeAttestationResolver
implements AttestationResolver {
    private final List<AttestationResolver> resolvers;

    public CompositeAttestationResolver(List<AttestationResolver> resolvers) {
        this.resolvers = CollectionUtil.immutableList(resolvers);
    }

    @Override
    public Optional<Attestation> resolve(X509Certificate attestationCertificate, List<X509Certificate> certificateChain) {
        for (AttestationResolver resolver : this.resolvers) {
            Optional<Attestation> result = resolver.resolve(attestationCertificate, certificateChain);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public Attestation untrustedFromCertificate(X509Certificate attestationCertificate) {
        if (this.resolvers.isEmpty()) {
            throw new UnsupportedOperationException("Cannot do this without any sub-resolver.");
        }
        return this.resolvers.get(0).untrustedFromCertificate(attestationCertificate);
    }
}

