/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation.resolver;

import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.attestation.TrustResolver;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;

public final class CompositeTrustResolver
implements TrustResolver {
    private final List<TrustResolver> resolvers;

    public CompositeTrustResolver(List<TrustResolver> resolvers) {
        this.resolvers = CollectionUtil.immutableList(resolvers);
    }

    @Override
    public Optional<X509Certificate> resolveTrustAnchor(X509Certificate attestationCertificate, List<X509Certificate> certificateChain) {
        for (TrustResolver resolver : this.resolvers) {
            Optional<X509Certificate> result = resolver.resolveTrustAnchor(attestationCertificate, certificateChain);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

