/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation.resolver;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.TrustResolver;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleTrustResolver
implements TrustResolver {
    private static final Logger logger = LoggerFactory.getLogger(SimpleTrustResolver.class);
    private final Multimap<String, X509Certificate> trustedCerts = ArrayListMultimap.create();

    public SimpleTrustResolver(Iterable<X509Certificate> trustedCertificates) {
        for (X509Certificate cert : trustedCertificates) {
            this.trustedCerts.put((Object)cert.getSubjectDN().getName(), (Object)cert);
        }
    }

    public static SimpleTrustResolver fromMetadata(Iterable<MetadataObject> metadataObjects) throws CertificateException {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        for (MetadataObject metadata : metadataObjects) {
            for (String encodedCert : metadata.getTrustedCertificates()) {
                certs.add(CertificateParser.parsePem((String)encodedCert));
            }
        }
        return new SimpleTrustResolver(certs);
    }

    public static SimpleTrustResolver fromMetadataJson(String metadataObjectJson) throws IOException, CertificateException {
        return SimpleTrustResolver.fromMetadata(Collections.singleton((MetadataObject)JacksonCodecs.json().readValue(metadataObjectJson, MetadataObject.class)));
    }

    @Override
    public Optional<X509Certificate> resolveTrustAnchor(X509Certificate attestationCertificate, List<X509Certificate> caCertificateChain) {
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        certChain.add(attestationCertificate);
        certChain.addAll(caCertificateChain);
        Certificate lastTriedCert = null;
        for (X509Certificate untrustedCert : certChain) {
            if (lastTriedCert != null) {
                logger.trace("No trusted certificate has signed certificate [{}] - trying next element in certificate chain.", lastTriedCert);
                try {
                    lastTriedCert.verify(untrustedCert.getPublicKey());
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                    logger.error("Failed to verify that certificate [{}] was signed by [{}]", new Object[]{lastTriedCert, untrustedCert, e});
                    throw new RuntimeException("Resolve failed", e);
                }
                catch (SignatureException e) {
                    logger.debug("Certificate chain broken - certificate [{}] was not signed by certificate [{}]", (Object)lastTriedCert, (Object)untrustedCert);
                    return Optional.empty();
                }
            }
            String issuer = untrustedCert.getIssuerDN().getName();
            for (X509Certificate trustedCert : this.trustedCerts.get((Object)issuer)) {
                try {
                    untrustedCert.verify(trustedCert.getPublicKey());
                    logger.debug("Found signature from trusted certificate [{}]", (Object)trustedCert);
                    return Optional.of(trustedCert);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                    logger.error("Resolve failed", (Throwable)e);
                    throw new RuntimeException("Resolve failed", e);
                }
                catch (SignatureException signatureException) {
                }
            }
            lastTriedCert = untrustedCert;
        }
        logger.debug("No trusted certificate has signed certificate chain {}", certChain);
        return Optional.empty();
    }
}

