/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation.resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.OptionalUtil;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.AttestationResolver;
import com.yubico.webauthn.attestation.DeviceMatcher;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.Transport;
import com.yubico.webauthn.attestation.TrustResolver;
import com.yubico.webauthn.attestation.matcher.ExtensionMatcher;
import com.yubico.webauthn.attestation.matcher.FingerprintMatcher;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

public final class SimpleAttestationResolver
implements AttestationResolver {
    private static final String SELECTORS = "selectors";
    private static final String SELECTOR_TYPE = "type";
    private static final String SELECTOR_PARAMETERS = "parameters";
    private static final String TRANSPORTS = "transports";
    private static final String TRANSPORTS_EXT_OID = "1.3.6.1.4.1.45724.2.1.1";
    private static final Map<String, DeviceMatcher> DEFAULT_DEVICE_MATCHERS = ImmutableMap.of((Object)"x509Extension", (Object)new ExtensionMatcher(), (Object)"fingerprint", (Object)new FingerprintMatcher());
    private final Map<X509Certificate, MetadataObject> metadata = new HashMap<X509Certificate, MetadataObject>();
    private final TrustResolver trustResolver;
    private final Map<String, DeviceMatcher> matchers;

    public SimpleAttestationResolver(@NonNull Collection<MetadataObject> objects, @NonNull TrustResolver trustResolver, @NonNull Map<String, DeviceMatcher> matchers) throws CertificateException {
        if (objects == null) {
            throw new NullPointerException("objects is marked non-null but is null");
        }
        if (trustResolver == null) {
            throw new NullPointerException("trustResolver is marked non-null but is null");
        }
        if (matchers == null) {
            throw new NullPointerException("matchers is marked non-null but is null");
        }
        for (MetadataObject object : objects) {
            for (String caPem : object.getTrustedCertificates()) {
                X509Certificate trustAnchor = CertificateParser.parsePem((String)caPem);
                this.metadata.put(trustAnchor, object);
            }
        }
        this.trustResolver = trustResolver;
        this.matchers = CollectionUtil.immutableMap(matchers);
    }

    public SimpleAttestationResolver(Collection<MetadataObject> objects, TrustResolver trustResolver) throws CertificateException {
        this(objects, trustResolver, DEFAULT_DEVICE_MATCHERS);
    }

    private Optional<MetadataObject> lookupTrustAnchor(X509Certificate trustAnchor) {
        return Optional.ofNullable(this.metadata.get(trustAnchor));
    }

    @Override
    public Optional<Attestation> resolve(X509Certificate attestationCertificate, List<X509Certificate> certificateChain) {
        Optional<X509Certificate> trustAnchor = this.trustResolver.resolveTrustAnchor(attestationCertificate, certificateChain);
        return trustAnchor.flatMap(this::lookupTrustAnchor).map(metadata -> {
            ImmutableMap deviceProperties = null;
            int metadataTransports = 0;
            String identifier = metadata.getIdentifier();
            Map vendorProperties = Maps.filterValues(metadata.getVendorInfo(), Objects::nonNull);
            for (JsonNode device : metadata.getDevices()) {
                if (!this.deviceMatches(device.get(SELECTORS), attestationCertificate)) continue;
                JsonNode transportNode = device.get(TRANSPORTS);
                if (transportNode != null) {
                    metadataTransports |= transportNode.asInt(0);
                }
                ImmutableMap.Builder devicePropertiesBuilder = ImmutableMap.builder();
                for (Map.Entry deviceEntry : Lists.newArrayList((Iterator)device.fields())) {
                    JsonNode value = (JsonNode)deviceEntry.getValue();
                    if (!value.isTextual()) continue;
                    devicePropertiesBuilder.put((Object)((String)deviceEntry.getKey()), (Object)value.asText());
                }
                deviceProperties = devicePropertiesBuilder.build();
                break;
            }
            return Attestation.builder().trusted(true).metadataIdentifier(Optional.ofNullable(identifier)).vendorProperties(Optional.of(vendorProperties)).deviceProperties(Optional.ofNullable(deviceProperties)).transports(OptionalUtil.zipWith(SimpleAttestationResolver.getTransports(attestationCertificate), Optional.of(metadataTransports).filter(t -> t != 0), (a, b) -> a | b).map(Transport::fromInt)).build();
        });
    }

    private boolean deviceMatches(JsonNode selectors, @NonNull X509Certificate attestationCertificate) {
        if (attestationCertificate == null) {
            throw new NullPointerException("attestationCertificate is marked non-null but is null");
        }
        if (selectors == null || selectors.isNull()) {
            return true;
        }
        for (JsonNode selector : selectors) {
            DeviceMatcher matcher = this.matchers.get(selector.get(SELECTOR_TYPE).asText());
            if (matcher == null || !matcher.matches(attestationCertificate, selector.get(SELECTOR_PARAMETERS))) continue;
            return true;
        }
        return false;
    }

    private static Optional<Integer> getTransports(X509Certificate cert) {
        byte[] extensionValue = cert.getExtensionValue(TRANSPORTS_EXT_OID);
        if (extensionValue == null) {
            return Optional.empty();
        }
        ExceptionUtil.assure((extensionValue.length >= 4 ? 1 : 0) != 0, (String)"Transports extension value must be at least 4 bytes (2 bytes octet string header, 2 bytes bit string header), was: %d", (Object[])new Object[]{extensionValue.length});
        int unusedBitMask = 255;
        for (int i = 0; i < extensionValue[3]; ++i) {
            unusedBitMask <<= 1;
        }
        int n = extensionValue.length - 1;
        extensionValue[n] = (byte)(extensionValue[n] & unusedBitMask);
        int transports = 0;
        for (int i = extensionValue.length - 1; i >= 5; --i) {
            byte b = extensionValue[i];
            for (int bi = 0; bi < 8; ++bi) {
                transports = transports << 1 | b & 1;
                b = (byte)(b >> 1);
            }
        }
        return Optional.of(transports);
    }

    @Override
    public Attestation untrustedFromCertificate(X509Certificate attestationCertificate) {
        return Attestation.builder().trusted(false).transports(SimpleAttestationResolver.getTransports(attestationCertificate).map(Transport::fromInt)).build();
    }
}

