/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.JacksonCodecs;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class MetadataObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataObject.class);
    private static final ObjectMapper OBJECT_MAPPER = JacksonCodecs.json();
    private static final TypeReference<Map<String, String>> MAP_STRING_STRING_TYPE = new TypeReference<Map<String, String>>(){};
    private static final TypeReference<List<String>> LIST_STRING_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<List<JsonNode>> LIST_JSONNODE_TYPE = new TypeReference<List<JsonNode>>(){};
    private final transient JsonNode data;
    private final String identifier;
    private final long version;
    private final Map<String, String> vendorInfo;
    private final List<String> trustedCertificates;
    private final List<JsonNode> devices;

    @JsonCreator
    public MetadataObject(JsonNode data) {
        this.data = data;
        try {
            this.vendorInfo = (Map)OBJECT_MAPPER.readValue(data.get("vendorInfo").traverse(), MAP_STRING_STRING_TYPE);
            this.trustedCertificates = (List)OBJECT_MAPPER.readValue(data.get("trustedCertificates").traverse(), LIST_STRING_TYPE);
            this.devices = (List)OBJECT_MAPPER.readValue(data.get("devices").traverse(), LIST_JSONNODE_TYPE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON data", e);
        }
        this.identifier = data.get("identifier").asText();
        this.version = data.get("version").asLong();
    }

    public static MetadataObject readDefault() {
        InputStream is = MetadataObject.class.getResourceAsStream("/metadata.json");
        try {
            MetadataObject metadataObject = (MetadataObject)JacksonCodecs.json().readValue(is, MetadataObject.class);
            return metadataObject;
        }
        catch (IOException e) {
            throw ExceptionUtil.wrapAndLog((Logger)log, (String)"Failed to read default metadata", (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public long getVersion() {
        return this.version;
    }

    public Map<String, String> getVendorInfo() {
        return this.vendorInfo;
    }

    public List<String> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    @JsonIgnore
    public List<X509Certificate> getParsedTrustedCertificates() throws CertificateException {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (String trustedCertificate : this.trustedCertificates) {
            X509Certificate x509Certificate = CertificateParser.parsePem((String)trustedCertificate);
            list.add(x509Certificate);
        }
        return list;
    }

    public List<JsonNode> getDevices() {
        return (List)MoreObjects.firstNonNull(this.devices, (Object)ImmutableList.of());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataObject)) {
            return false;
        }
        MetadataObject other = (MetadataObject)o;
        JsonNode this$data = this.data;
        JsonNode other$data = other.data;
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonNode $data = this.data;
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

