/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.AttestationResolver;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.MetadataService;
import com.yubico.webauthn.attestation.TrustResolver;
import com.yubico.webauthn.attestation.resolver.SimpleAttestationResolver;
import com.yubico.webauthn.attestation.resolver.SimpleTrustResolver;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardMetadataService
implements MetadataService {
    private static final Logger logger = LoggerFactory.getLogger(StandardMetadataService.class);
    private final Attestation unknownAttestation = Attestation.empty();
    private final AttestationResolver attestationResolver;
    private final Cache<String, Attestation> cache;

    private StandardMetadataService(@NonNull AttestationResolver attestationResolver, @NonNull Cache<String, Attestation> cache) {
        if (attestationResolver == null) {
            throw new NullPointerException("attestationResolver is marked non-null but is null");
        }
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        this.attestationResolver = attestationResolver;
        this.cache = cache;
    }

    public StandardMetadataService(AttestationResolver attestationResolver) {
        this(attestationResolver, (Cache<String, Attestation>)CacheBuilder.newBuilder().build());
    }

    public StandardMetadataService() throws CertificateException {
        this(StandardMetadataService.createDefaultAttestationResolver());
    }

    public static TrustResolver createDefaultTrustResolver() throws CertificateException {
        return SimpleTrustResolver.fromMetadata(Collections.singleton(MetadataObject.readDefault()));
    }

    public static AttestationResolver createDefaultAttestationResolver(TrustResolver trustResolver) throws CertificateException {
        return new SimpleAttestationResolver(Collections.singleton(MetadataObject.readDefault()), trustResolver);
    }

    public static AttestationResolver createDefaultAttestationResolver() throws CertificateException {
        return StandardMetadataService.createDefaultAttestationResolver(StandardMetadataService.createDefaultTrustResolver());
    }

    public Attestation getCachedAttestation(String attestationCertificateFingerprint) {
        return (Attestation)this.cache.getIfPresent((Object)attestationCertificateFingerprint);
    }

    public Attestation getAttestation(@NonNull List<X509Certificate> attestationCertificateChain) throws CertificateEncodingException {
        if (attestationCertificateChain == null) {
            throw new NullPointerException("attestationCertificateChain is marked non-null but is null");
        }
        if (attestationCertificateChain.isEmpty()) {
            return this.unknownAttestation;
        }
        X509Certificate attestationCertificate = attestationCertificateChain.get(0);
        List<X509Certificate> certificateChain = attestationCertificateChain.subList(1, attestationCertificateChain.size());
        try {
            String fingerprint = Hashing.sha1().hashBytes(attestationCertificate.getEncoded()).toString();
            return (Attestation)this.cache.get((Object)fingerprint, () -> this.attestationResolver.resolve(attestationCertificate, certificateChain).orElseGet(() -> this.attestationResolver.untrustedFromCertificate(attestationCertificate)));
        }
        catch (ExecutionException e) {
            throw ExceptionUtil.wrapAndLog((Logger)logger, (String)("Failed to look up attestation information for certificate: " + attestationCertificate), (Throwable)e);
        }
    }
}

