/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.fido.metadata.CertFromBase64Converter;
import com.yubico.fido.metadata.CertToBase64Converter;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=MetadataBLOBHeaderBuilder.class)
public final class MetadataBLOBHeader {
    private final String typ;
    @NonNull
    private final String alg;
    private final URL x5u;
    @JsonDeserialize(contentConverter=CertFromBase64Converter.class)
    @JsonSerialize(contentConverter=CertToBase64Converter.class)
    private final List<X509Certificate> x5c;

    private MetadataBLOBHeader(String typ, @NonNull String alg, URL x5u, List<X509Certificate> x5c) {
        if (alg == null) {
            throw new NullPointerException("alg is marked non-null but is null");
        }
        this.typ = typ;
        this.alg = alg;
        this.x5u = x5u;
        this.x5c = x5c;
        if (typ != null && !typ.equals("JWT")) {
            throw new IllegalArgumentException("Unsupported JWT type: " + typ);
        }
    }

    public Optional<String> getTyp() {
        return Optional.ofNullable(this.typ);
    }

    public Optional<URL> getX5u() {
        return Optional.ofNullable(this.x5u);
    }

    @JsonIgnore
    public Optional<List<X509Certificate>> getX5c() {
        return Optional.ofNullable(this.x5c);
    }

    @Generated
    public static MetadataBLOBHeaderBuilder builder() {
        return new MetadataBLOBHeaderBuilder();
    }

    @Generated
    public MetadataBLOBHeaderBuilder toBuilder() {
        return new MetadataBLOBHeaderBuilder().typ(this.typ).alg(this.alg).x5u(this.x5u).x5c(this.x5c);
    }

    @NonNull
    @Generated
    public String getAlg() {
        return this.alg;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataBLOBHeader)) {
            return false;
        }
        MetadataBLOBHeader other = (MetadataBLOBHeader)o;
        Optional<String> this$typ = this.getTyp();
        Optional<String> other$typ = other.getTyp();
        if (this$typ == null ? other$typ != null : !((Object)this$typ).equals(other$typ)) {
            return false;
        }
        String this$alg = this.getAlg();
        String other$alg = other.getAlg();
        if (this$alg == null ? other$alg != null : !this$alg.equals(other$alg)) {
            return false;
        }
        Optional<URL> this$x5u = this.getX5u();
        Optional<URL> other$x5u = other.getX5u();
        if (this$x5u == null ? other$x5u != null : !((Object)this$x5u).equals(other$x5u)) {
            return false;
        }
        Optional<List<X509Certificate>> this$x5c = this.getX5c();
        Optional<List<X509Certificate>> other$x5c = other.getX5c();
        return !(this$x5c == null ? other$x5c != null : !((Object)this$x5c).equals(other$x5c));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $typ = this.getTyp();
        result = result * 59 + ($typ == null ? 43 : ((Object)$typ).hashCode());
        String $alg = this.getAlg();
        result = result * 59 + ($alg == null ? 43 : $alg.hashCode());
        Optional<URL> $x5u = this.getX5u();
        result = result * 59 + ($x5u == null ? 43 : ((Object)$x5u).hashCode());
        Optional<List<X509Certificate>> $x5c = this.getX5c();
        result = result * 59 + ($x5c == null ? 43 : ((Object)$x5c).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetadataBLOBHeader(typ=" + this.getTyp() + ", alg=" + this.getAlg() + ", x5u=" + this.getX5u() + ", x5c=" + this.getX5c() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class MetadataBLOBHeaderBuilder {
        @Generated
        private String typ;
        @Generated
        private String alg;
        @Generated
        private URL x5u;
        @Generated
        private List<X509Certificate> x5c;

        @Generated
        MetadataBLOBHeaderBuilder() {
        }

        @Generated
        public MetadataBLOBHeaderBuilder typ(String typ) {
            this.typ = typ;
            return this;
        }

        @Generated
        public MetadataBLOBHeaderBuilder alg(@NonNull String alg) {
            if (alg == null) {
                throw new NullPointerException("alg is marked non-null but is null");
            }
            this.alg = alg;
            return this;
        }

        @Generated
        public MetadataBLOBHeaderBuilder x5u(URL x5u) {
            this.x5u = x5u;
            return this;
        }

        @JsonDeserialize(contentConverter=CertFromBase64Converter.class)
        @Generated
        public MetadataBLOBHeaderBuilder x5c(List<X509Certificate> x5c) {
            this.x5c = x5c;
            return this;
        }

        @Generated
        public MetadataBLOBHeader build() {
            return new MetadataBLOBHeader(this.typ, this.alg, this.x5u, this.x5c);
        }

        @Generated
        public String toString() {
            return "MetadataBLOBHeader.MetadataBLOBHeaderBuilder(typ=" + this.typ + ", alg=" + this.alg + ", x5u=" + this.x5u + ", x5c=" + this.x5c + ")";
        }
    }
}

