/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.ResidentKeyRequirement;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class AuthenticatorSelectionCriteria {
    private final AuthenticatorAttachment authenticatorAttachment;
    private final ResidentKeyRequirement residentKey;
    private final UserVerificationRequirement userVerification;

    public Optional<AuthenticatorAttachment> getAuthenticatorAttachment() {
        return Optional.ofNullable(this.authenticatorAttachment);
    }

    @Deprecated
    public boolean isRequireResidentKey() {
        return this.residentKey == ResidentKeyRequirement.REQUIRED;
    }

    @JsonCreator
    private AuthenticatorSelectionCriteria(@JsonProperty(value="authenticatorAttachment") AuthenticatorAttachment authenticatorAttachment, @JsonProperty(value="requireResidentKey") Boolean requireResidentKey, @JsonProperty(value="residentKey") ResidentKeyRequirement residentKey, @JsonProperty(value="userVerification") UserVerificationRequirement userVerification) {
        this.authenticatorAttachment = authenticatorAttachment;
        this.residentKey = residentKey == null && requireResidentKey != null ? (requireResidentKey != false ? ResidentKeyRequirement.REQUIRED : ResidentKeyRequirement.DISCOURAGED) : (residentKey == null ? ResidentKeyRequirement.DISCOURAGED : residentKey);
        this.userVerification = userVerification == null ? UserVerificationRequirement.PREFERRED : userVerification;
    }

    private AuthenticatorSelectionCriteria(AuthenticatorAttachment authenticatorAttachment, ResidentKeyRequirement residentKey, UserVerificationRequirement userVerification) {
        this(authenticatorAttachment, null, residentKey, userVerification);
    }

    @Generated
    public static AuthenticatorSelectionCriteriaBuilder builder() {
        return new AuthenticatorSelectionCriteriaBuilder();
    }

    @Generated
    public AuthenticatorSelectionCriteriaBuilder toBuilder() {
        return new AuthenticatorSelectionCriteriaBuilder().authenticatorAttachment(this.authenticatorAttachment).residentKey(this.residentKey).userVerification(this.userVerification);
    }

    @Generated
    public ResidentKeyRequirement getResidentKey() {
        return this.residentKey;
    }

    @Generated
    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorSelectionCriteria)) {
            return false;
        }
        AuthenticatorSelectionCriteria other = (AuthenticatorSelectionCriteria)o;
        Optional<AuthenticatorAttachment> this$authenticatorAttachment = this.getAuthenticatorAttachment();
        Optional<AuthenticatorAttachment> other$authenticatorAttachment = other.getAuthenticatorAttachment();
        if (this$authenticatorAttachment == null ? other$authenticatorAttachment != null : !((Object)this$authenticatorAttachment).equals(other$authenticatorAttachment)) {
            return false;
        }
        ResidentKeyRequirement this$residentKey = this.getResidentKey();
        ResidentKeyRequirement other$residentKey = other.getResidentKey();
        if (this$residentKey == null ? other$residentKey != null : !((Object)((Object)this$residentKey)).equals((Object)other$residentKey)) {
            return false;
        }
        UserVerificationRequirement this$userVerification = this.getUserVerification();
        UserVerificationRequirement other$userVerification = other.getUserVerification();
        return !(this$userVerification == null ? other$userVerification != null : !((Object)((Object)this$userVerification)).equals((Object)other$userVerification));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<AuthenticatorAttachment> $authenticatorAttachment = this.getAuthenticatorAttachment();
        result = result * 59 + ($authenticatorAttachment == null ? 43 : ((Object)$authenticatorAttachment).hashCode());
        ResidentKeyRequirement $residentKey = this.getResidentKey();
        result = result * 59 + ($residentKey == null ? 43 : ((Object)((Object)$residentKey)).hashCode());
        UserVerificationRequirement $userVerification = this.getUserVerification();
        result = result * 59 + ($userVerification == null ? 43 : ((Object)((Object)$userVerification)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorSelectionCriteria(authenticatorAttachment=" + this.getAuthenticatorAttachment() + ", residentKey=" + (Object)((Object)this.getResidentKey()) + ", userVerification=" + (Object)((Object)this.getUserVerification()) + ")";
    }

    public static class AuthenticatorSelectionCriteriaBuilder {
        @Generated
        private ResidentKeyRequirement residentKey;
        @Generated
        private UserVerificationRequirement userVerification;
        private AuthenticatorAttachment authenticatorAttachment = null;

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(@NonNull Optional<AuthenticatorAttachment> authenticatorAttachment) {
            if (authenticatorAttachment == null) {
                throw new NullPointerException("authenticatorAttachment is marked non-null but is null");
            }
            return this.authenticatorAttachment((AuthenticatorAttachment)authenticatorAttachment.orElse(null));
        }

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        @Deprecated
        public AuthenticatorSelectionCriteriaBuilder requireResidentKey(boolean requireResidentKey) {
            return this.residentKey(requireResidentKey ? ResidentKeyRequirement.REQUIRED : ResidentKeyRequirement.DISCOURAGED);
        }

        @Generated
        AuthenticatorSelectionCriteriaBuilder() {
        }

        @Generated
        public AuthenticatorSelectionCriteriaBuilder residentKey(ResidentKeyRequirement residentKey) {
            this.residentKey = residentKey;
            return this;
        }

        @Generated
        public AuthenticatorSelectionCriteriaBuilder userVerification(UserVerificationRequirement userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        @Generated
        public AuthenticatorSelectionCriteria build() {
            return new AuthenticatorSelectionCriteria(this.authenticatorAttachment, this.residentKey, this.userVerification);
        }

        @Generated
        public String toString() {
            return "AuthenticatorSelectionCriteria.AuthenticatorSelectionCriteriaBuilder(authenticatorAttachment=" + (Object)((Object)this.authenticatorAttachment) + ", residentKey=" + (Object)((Object)this.residentKey) + ", userVerification=" + (Object)((Object)this.userVerification) + ")";
        }
    }
}

