/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.upokecenter.cbor.CBORObject;
import com.yubico.webauthn.data.AuthenticatorResponse;
import com.yubico.webauthn.data.ClientExtensionOutputs;
import com.yubico.webauthn.data.ExtensionInputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

final class ExtensionsValidation {
    static boolean validate(ExtensionInputs requested, PublicKeyCredential<? extends AuthenticatorResponse, ? extends ClientExtensionOutputs> response) {
        Set<String> clientExtensionIds;
        Set<String> requestedExtensionIds = requested.getExtensionIds();
        if (!requestedExtensionIds.containsAll(clientExtensionIds = response.getClientExtensionResults().getExtensionIds())) {
            throw new IllegalArgumentException(String.format("Client extensions {%s} are not a subset of requested extensions {%s}.", String.join((CharSequence)", ", clientExtensionIds), String.join((CharSequence)", ", requestedExtensionIds)));
        }
        Set authenticatorExtensionIds = response.getResponse().getParsedAuthenticatorData().getExtensions().map(extensions -> extensions.getKeys().stream().map(CBORObject::AsString).collect(Collectors.toSet())).orElseGet(HashSet::new);
        if (!requestedExtensionIds.containsAll(authenticatorExtensionIds)) {
            throw new IllegalArgumentException(String.format("Authenticator extensions {%s} are not a subset of requested extensions {%s}.", String.join((CharSequence)", ", authenticatorExtensionIds), String.join((CharSequence)", ", requestedExtensionIds)));
        }
        return true;
    }

    @Generated
    private ExtensionsValidation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

