/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.AssertionExtensionInputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class PublicKeyCredentialRequestOptions {
    @NonNull
    private final ByteArray challenge;
    @NonNull
    private final Optional<Long> timeout;
    @NonNull
    private final Optional<String> rpId;
    @NonNull
    private final Optional<List<PublicKeyCredentialDescriptor>> allowCredentials;
    @NonNull
    private final UserVerificationRequirement userVerification;
    @NonNull
    private final AssertionExtensionInputs extensions;

    private PublicKeyCredentialRequestOptions(@NonNull ByteArray challenge, @NonNull Optional<Long> timeout, @NonNull Optional<String> rpId, @NonNull Optional<List<PublicKeyCredentialDescriptor>> allowCredentials, @NonNull UserVerificationRequirement userVerification, @NonNull AssertionExtensionInputs extensions) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked @NonNull but is null");
        }
        if (timeout == null) {
            throw new NullPointerException("timeout is marked @NonNull but is null");
        }
        if (rpId == null) {
            throw new NullPointerException("rpId is marked @NonNull but is null");
        }
        if (allowCredentials == null) {
            throw new NullPointerException("allowCredentials is marked @NonNull but is null");
        }
        if (userVerification == null) {
            throw new NullPointerException("userVerification is marked @NonNull but is null");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions is marked @NonNull but is null");
        }
        this.challenge = challenge;
        this.timeout = timeout;
        this.rpId = rpId;
        this.allowCredentials = allowCredentials.map(CollectionUtil::immutableList);
        this.userVerification = userVerification;
        this.extensions = extensions;
    }

    @JsonCreator
    private PublicKeyCredentialRequestOptions(@JsonProperty(value="challenge") @NonNull ByteArray challenge, @JsonProperty(value="timeout") Long timeout, @JsonProperty(value="rpId") String rpId, @JsonProperty(value="allowCredentials") List<PublicKeyCredentialDescriptor> allowCredentials, @JsonProperty(value="userVerification") @NonNull UserVerificationRequirement userVerification, @JsonProperty(value="extensions") AssertionExtensionInputs extensions) {
        this(challenge, Optional.ofNullable(timeout), Optional.ofNullable(rpId), Optional.ofNullable(allowCredentials), userVerification, Optional.ofNullable(extensions).orElseGet(() -> AssertionExtensionInputs.builder().build()));
        if (challenge == null) {
            throw new NullPointerException("challenge is marked @NonNull but is null");
        }
        if (userVerification == null) {
            throw new NullPointerException("userVerification is marked @NonNull but is null");
        }
    }

    public static PublicKeyCredentialRequestOptionsBuilder.MandatoryStages builder() {
        return new PublicKeyCredentialRequestOptionsBuilder.MandatoryStages();
    }

    @Generated
    private static Optional<Long> $default$timeout() {
        return Optional.empty();
    }

    @Generated
    private static Optional<String> $default$rpId() {
        return Optional.empty();
    }

    @Generated
    private static Optional<List<PublicKeyCredentialDescriptor>> $default$allowCredentials() {
        return Optional.empty();
    }

    @Generated
    private static UserVerificationRequirement $default$userVerification() {
        return UserVerificationRequirement.PREFERRED;
    }

    @Generated
    private static AssertionExtensionInputs $default$extensions() {
        return AssertionExtensionInputs.builder().build();
    }

    @Generated
    public PublicKeyCredentialRequestOptionsBuilder toBuilder() {
        return new PublicKeyCredentialRequestOptionsBuilder().challenge(this.challenge).timeout(this.timeout).rpId(this.rpId).allowCredentials(this.allowCredentials).userVerification(this.userVerification).extensions(this.extensions);
    }

    @NonNull
    @Generated
    public ByteArray getChallenge() {
        return this.challenge;
    }

    @NonNull
    @Generated
    public Optional<Long> getTimeout() {
        return this.timeout;
    }

    @NonNull
    @Generated
    public Optional<String> getRpId() {
        return this.rpId;
    }

    @NonNull
    @Generated
    public Optional<List<PublicKeyCredentialDescriptor>> getAllowCredentials() {
        return this.allowCredentials;
    }

    @NonNull
    @Generated
    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    @NonNull
    @Generated
    public AssertionExtensionInputs getExtensions() {
        return this.extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyCredentialRequestOptions)) {
            return false;
        }
        PublicKeyCredentialRequestOptions other = (PublicKeyCredentialRequestOptions)o;
        ByteArray this$challenge = this.getChallenge();
        ByteArray other$challenge = other.getChallenge();
        if (this$challenge == null ? other$challenge != null : !((Object)this$challenge).equals(other$challenge)) {
            return false;
        }
        Optional<Long> this$timeout = this.getTimeout();
        Optional<Long> other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Optional<String> this$rpId = this.getRpId();
        Optional<String> other$rpId = other.getRpId();
        if (this$rpId == null ? other$rpId != null : !((Object)this$rpId).equals(other$rpId)) {
            return false;
        }
        Optional<List<PublicKeyCredentialDescriptor>> this$allowCredentials = this.getAllowCredentials();
        Optional<List<PublicKeyCredentialDescriptor>> other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        UserVerificationRequirement this$userVerification = this.getUserVerification();
        UserVerificationRequirement other$userVerification = other.getUserVerification();
        if (this$userVerification == null ? other$userVerification != null : !((Object)((Object)this$userVerification)).equals((Object)other$userVerification)) {
            return false;
        }
        AssertionExtensionInputs this$extensions = this.getExtensions();
        AssertionExtensionInputs other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $challenge = this.getChallenge();
        result = result * 59 + ($challenge == null ? 43 : ((Object)$challenge).hashCode());
        Optional<Long> $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Optional<String> $rpId = this.getRpId();
        result = result * 59 + ($rpId == null ? 43 : ((Object)$rpId).hashCode());
        Optional<List<PublicKeyCredentialDescriptor>> $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        UserVerificationRequirement $userVerification = this.getUserVerification();
        result = result * 59 + ($userVerification == null ? 43 : ((Object)((Object)$userVerification)).hashCode());
        AssertionExtensionInputs $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyCredentialRequestOptions(challenge=" + this.getChallenge() + ", timeout=" + this.getTimeout() + ", rpId=" + this.getRpId() + ", allowCredentials=" + this.getAllowCredentials() + ", userVerification=" + (Object)((Object)this.getUserVerification()) + ", extensions=" + this.getExtensions() + ")";
    }

    public static class PublicKeyCredentialRequestOptionsBuilder {
        @Generated
        private ByteArray challenge;
        @Generated
        private boolean timeout$set;
        @Generated
        private Optional<Long> timeout;
        @Generated
        private boolean rpId$set;
        @Generated
        private Optional<String> rpId;
        @Generated
        private boolean allowCredentials$set;
        @Generated
        private Optional<List<PublicKeyCredentialDescriptor>> allowCredentials;
        @Generated
        private boolean userVerification$set;
        @Generated
        private UserVerificationRequirement userVerification;
        @Generated
        private boolean extensions$set;
        @Generated
        private AssertionExtensionInputs extensions;

        @Generated
        PublicKeyCredentialRequestOptionsBuilder() {
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder challenge(@NonNull ByteArray challenge) {
            if (challenge == null) {
                throw new NullPointerException("challenge is marked @NonNull but is null");
            }
            this.challenge = challenge;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder timeout(@NonNull Optional<Long> timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked @NonNull but is null");
            }
            this.timeout = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder rpId(@NonNull Optional<String> rpId) {
            if (rpId == null) {
                throw new NullPointerException("rpId is marked @NonNull but is null");
            }
            this.rpId = rpId;
            this.rpId$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder allowCredentials(@NonNull Optional<List<PublicKeyCredentialDescriptor>> allowCredentials) {
            if (allowCredentials == null) {
                throw new NullPointerException("allowCredentials is marked @NonNull but is null");
            }
            this.allowCredentials = allowCredentials;
            this.allowCredentials$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder userVerification(@NonNull UserVerificationRequirement userVerification) {
            if (userVerification == null) {
                throw new NullPointerException("userVerification is marked @NonNull but is null");
            }
            this.userVerification = userVerification;
            this.userVerification$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder extensions(@NonNull AssertionExtensionInputs extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions is marked @NonNull but is null");
            }
            this.extensions = extensions;
            this.extensions$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptions build() {
            Optional timeout = this.timeout;
            if (!this.timeout$set) {
                timeout = PublicKeyCredentialRequestOptions.$default$timeout();
            }
            Optional rpId = this.rpId;
            if (!this.rpId$set) {
                rpId = PublicKeyCredentialRequestOptions.$default$rpId();
            }
            Optional allowCredentials = this.allowCredentials;
            if (!this.allowCredentials$set) {
                allowCredentials = PublicKeyCredentialRequestOptions.$default$allowCredentials();
            }
            UserVerificationRequirement userVerification = this.userVerification;
            if (!this.userVerification$set) {
                userVerification = PublicKeyCredentialRequestOptions.$default$userVerification();
            }
            AssertionExtensionInputs extensions = this.extensions;
            if (!this.extensions$set) {
                extensions = PublicKeyCredentialRequestOptions.$default$extensions();
            }
            return new PublicKeyCredentialRequestOptions(this.challenge, timeout, rpId, allowCredentials, userVerification, extensions);
        }

        @Generated
        public String toString() {
            return "PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder(challenge=" + this.challenge + ", timeout=" + this.timeout + ", rpId=" + this.rpId + ", allowCredentials=" + this.allowCredentials + ", userVerification=" + (Object)((Object)this.userVerification) + ", extensions=" + this.extensions + ")";
        }

        public static class MandatoryStages {
            private PublicKeyCredentialRequestOptionsBuilder builder = new PublicKeyCredentialRequestOptionsBuilder();

            public PublicKeyCredentialRequestOptionsBuilder challenge(ByteArray challenge) {
                return this.builder.challenge(challenge);
            }
        }
    }
}

