/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishAssertionSteps;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.FinishRegistrationSteps;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.attestation.MetadataService;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialParameters;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import com.yubico.webauthn.extension.appid.AppId;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public final class RelyingParty {
    private static final SecureRandom random = new SecureRandom();
    @NonNull
    private final RelyingPartyIdentity identity;
    @NonNull
    private final Set<String> origins;
    @NonNull
    private final CredentialRepository credentialRepository;
    @NonNull
    private final Optional<AppId> appId;
    @NonNull
    private final Optional<AttestationConveyancePreference> attestationConveyancePreference;
    @NonNull
    private final Optional<MetadataService> metadataService;
    @NonNull
    private final List<PublicKeyCredentialParameters> preferredPubkeyParams;
    private final boolean allowUnrequestedExtensions;
    private final boolean allowUntrustedAttestation;
    private final boolean validateSignatureCounter;

    private RelyingParty(@NonNull RelyingPartyIdentity identity, Set<String> origins, @NonNull CredentialRepository credentialRepository, @NonNull Optional<AppId> appId, @NonNull Optional<AttestationConveyancePreference> attestationConveyancePreference, @NonNull Optional<MetadataService> metadataService, List<PublicKeyCredentialParameters> preferredPubkeyParams, boolean allowUnrequestedExtensions, boolean allowUntrustedAttestation, boolean validateSignatureCounter) {
        if (identity == null) {
            throw new NullPointerException("identity is marked @NonNull but is null");
        }
        if (credentialRepository == null) {
            throw new NullPointerException("credentialRepository is marked @NonNull but is null");
        }
        if (appId == null) {
            throw new NullPointerException("appId is marked @NonNull but is null");
        }
        if (attestationConveyancePreference == null) {
            throw new NullPointerException("attestationConveyancePreference is marked @NonNull but is null");
        }
        if (metadataService == null) {
            throw new NullPointerException("metadataService is marked @NonNull but is null");
        }
        this.identity = identity;
        this.origins = origins != null ? origins : Collections.singleton("https://" + identity.getId());
        this.credentialRepository = credentialRepository;
        this.appId = appId;
        this.attestationConveyancePreference = attestationConveyancePreference;
        this.metadataService = metadataService;
        this.preferredPubkeyParams = preferredPubkeyParams;
        this.allowUnrequestedExtensions = allowUnrequestedExtensions;
        this.allowUntrustedAttestation = allowUntrustedAttestation;
        this.validateSignatureCounter = validateSignatureCounter;
    }

    private static ByteArray generateChallenge() {
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return new ByteArray(bytes);
    }

    public PublicKeyCredentialCreationOptions startRegistration(StartRegistrationOptions startRegistrationOptions) {
        PublicKeyCredentialCreationOptions.PublicKeyCredentialCreationOptionsBuilder builder = PublicKeyCredentialCreationOptions.builder().rp(this.identity).user(startRegistrationOptions.getUser()).challenge(RelyingParty.generateChallenge()).pubKeyCredParams(this.preferredPubkeyParams).excludeCredentials(this.credentialRepository.getCredentialIdsForUsername(startRegistrationOptions.getUser().getName())).authenticatorSelection(startRegistrationOptions.getAuthenticatorSelection()).extensions(startRegistrationOptions.getExtensions());
        this.attestationConveyancePreference.ifPresent(builder::attestation);
        return builder.build();
    }

    public RegistrationResult finishRegistration(FinishRegistrationOptions finishRegistrationOptions) throws RegistrationFailedException {
        try {
            return this._finishRegistration(finishRegistrationOptions.getRequest(), finishRegistrationOptions.getResponse(), finishRegistrationOptions.getCallerTokenBindingId()).run();
        }
        catch (IllegalArgumentException e) {
            throw new RegistrationFailedException(e);
        }
    }

    FinishRegistrationSteps _finishRegistration(PublicKeyCredentialCreationOptions request, PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response, Optional<ByteArray> callerTokenBindingId) {
        return FinishRegistrationSteps.builder().request(request).response(response).callerTokenBindingId(callerTokenBindingId).credentialRepository(this.credentialRepository).origins(this.origins).rpId(this.identity.getId()).allowUnrequestedExtensions(this.allowUnrequestedExtensions).allowUntrustedAttestation(this.allowUntrustedAttestation).metadataService(this.metadataService).build();
    }

    public AssertionRequest startAssertion(StartAssertionOptions startAssertionOptions) {
        PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder pkcro = PublicKeyCredentialRequestOptions.builder().challenge(RelyingParty.generateChallenge()).rpId(this.identity.getId()).allowCredentials(startAssertionOptions.getUsername().map(un -> new ArrayList<PublicKeyCredentialDescriptor>(this.credentialRepository.getCredentialIdsForUsername((String)un)))).extensions(startAssertionOptions.getExtensions().toBuilder().appid(this.appId).build());
        startAssertionOptions.getUserVerification().ifPresent(pkcro::userVerification);
        return AssertionRequest.builder().publicKeyCredentialRequestOptions(pkcro.build()).username(startAssertionOptions.getUsername()).build();
    }

    public AssertionResult finishAssertion(FinishAssertionOptions finishAssertionOptions) throws AssertionFailedException {
        try {
            return this._finishAssertion(finishAssertionOptions.getRequest(), finishAssertionOptions.getResponse(), finishAssertionOptions.getCallerTokenBindingId()).run();
        }
        catch (IllegalArgumentException e) {
            throw new AssertionFailedException(e);
        }
    }

    FinishAssertionSteps _finishAssertion(AssertionRequest request, PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response, Optional<ByteArray> callerTokenBindingId) {
        return FinishAssertionSteps.builder().request(request).response(response).callerTokenBindingId(callerTokenBindingId).origins(this.origins).rpId(this.identity.getId()).credentialRepository(this.credentialRepository).allowUnrequestedExtensions(this.allowUnrequestedExtensions).validateSignatureCounter(this.validateSignatureCounter).build();
    }

    public static RelyingPartyBuilder.MandatoryStages builder() {
        return new RelyingPartyBuilder.MandatoryStages();
    }

    @Generated
    private static List<PublicKeyCredentialParameters> $default$preferredPubkeyParams() {
        return Collections.unmodifiableList(Arrays.asList(PublicKeyCredentialParameters.ES256, PublicKeyCredentialParameters.RS256));
    }

    @Generated
    private static boolean $default$allowUnrequestedExtensions() {
        return false;
    }

    @Generated
    private static boolean $default$allowUntrustedAttestation() {
        return true;
    }

    @Generated
    private static boolean $default$validateSignatureCounter() {
        return true;
    }

    @Generated
    public RelyingPartyBuilder toBuilder() {
        return new RelyingPartyBuilder().identity(this.identity).origins(this.origins).credentialRepository(this.credentialRepository).appId(this.appId).attestationConveyancePreference(this.attestationConveyancePreference).metadataService(this.metadataService).preferredPubkeyParams(this.preferredPubkeyParams).allowUnrequestedExtensions(this.allowUnrequestedExtensions).allowUntrustedAttestation(this.allowUntrustedAttestation).validateSignatureCounter(this.validateSignatureCounter);
    }

    @NonNull
    @Generated
    public RelyingPartyIdentity getIdentity() {
        return this.identity;
    }

    @NonNull
    @Generated
    public Set<String> getOrigins() {
        return this.origins;
    }

    @NonNull
    @Generated
    public CredentialRepository getCredentialRepository() {
        return this.credentialRepository;
    }

    @NonNull
    @Generated
    public Optional<AppId> getAppId() {
        return this.appId;
    }

    @NonNull
    @Generated
    public Optional<AttestationConveyancePreference> getAttestationConveyancePreference() {
        return this.attestationConveyancePreference;
    }

    @NonNull
    @Generated
    public Optional<MetadataService> getMetadataService() {
        return this.metadataService;
    }

    @NonNull
    @Generated
    public List<PublicKeyCredentialParameters> getPreferredPubkeyParams() {
        return this.preferredPubkeyParams;
    }

    @Generated
    public boolean isAllowUnrequestedExtensions() {
        return this.allowUnrequestedExtensions;
    }

    @Generated
    public boolean isAllowUntrustedAttestation() {
        return this.allowUntrustedAttestation;
    }

    @Generated
    public boolean isValidateSignatureCounter() {
        return this.validateSignatureCounter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelyingParty)) {
            return false;
        }
        RelyingParty other = (RelyingParty)o;
        RelyingPartyIdentity this$identity = this.getIdentity();
        RelyingPartyIdentity other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !((Object)this$identity).equals(other$identity)) {
            return false;
        }
        Set<String> this$origins = this.getOrigins();
        Set<String> other$origins = other.getOrigins();
        if (this$origins == null ? other$origins != null : !((Object)this$origins).equals(other$origins)) {
            return false;
        }
        CredentialRepository this$credentialRepository = this.getCredentialRepository();
        CredentialRepository other$credentialRepository = other.getCredentialRepository();
        if (this$credentialRepository == null ? other$credentialRepository != null : !this$credentialRepository.equals(other$credentialRepository)) {
            return false;
        }
        Optional<AppId> this$appId = this.getAppId();
        Optional<AppId> other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        Optional<AttestationConveyancePreference> this$attestationConveyancePreference = this.getAttestationConveyancePreference();
        Optional<AttestationConveyancePreference> other$attestationConveyancePreference = other.getAttestationConveyancePreference();
        if (this$attestationConveyancePreference == null ? other$attestationConveyancePreference != null : !((Object)this$attestationConveyancePreference).equals(other$attestationConveyancePreference)) {
            return false;
        }
        Optional<MetadataService> this$metadataService = this.getMetadataService();
        Optional<MetadataService> other$metadataService = other.getMetadataService();
        if (this$metadataService == null ? other$metadataService != null : !((Object)this$metadataService).equals(other$metadataService)) {
            return false;
        }
        List<PublicKeyCredentialParameters> this$preferredPubkeyParams = this.getPreferredPubkeyParams();
        List<PublicKeyCredentialParameters> other$preferredPubkeyParams = other.getPreferredPubkeyParams();
        if (this$preferredPubkeyParams == null ? other$preferredPubkeyParams != null : !((Object)this$preferredPubkeyParams).equals(other$preferredPubkeyParams)) {
            return false;
        }
        if (this.isAllowUnrequestedExtensions() != other.isAllowUnrequestedExtensions()) {
            return false;
        }
        if (this.isAllowUntrustedAttestation() != other.isAllowUntrustedAttestation()) {
            return false;
        }
        return this.isValidateSignatureCounter() == other.isValidateSignatureCounter();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelyingPartyIdentity $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : ((Object)$identity).hashCode());
        Set<String> $origins = this.getOrigins();
        result = result * 59 + ($origins == null ? 43 : ((Object)$origins).hashCode());
        CredentialRepository $credentialRepository = this.getCredentialRepository();
        result = result * 59 + ($credentialRepository == null ? 43 : $credentialRepository.hashCode());
        Optional<AppId> $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        Optional<AttestationConveyancePreference> $attestationConveyancePreference = this.getAttestationConveyancePreference();
        result = result * 59 + ($attestationConveyancePreference == null ? 43 : ((Object)$attestationConveyancePreference).hashCode());
        Optional<MetadataService> $metadataService = this.getMetadataService();
        result = result * 59 + ($metadataService == null ? 43 : ((Object)$metadataService).hashCode());
        List<PublicKeyCredentialParameters> $preferredPubkeyParams = this.getPreferredPubkeyParams();
        result = result * 59 + ($preferredPubkeyParams == null ? 43 : ((Object)$preferredPubkeyParams).hashCode());
        result = result * 59 + (this.isAllowUnrequestedExtensions() ? 79 : 97);
        result = result * 59 + (this.isAllowUntrustedAttestation() ? 79 : 97);
        result = result * 59 + (this.isValidateSignatureCounter() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "RelyingParty(identity=" + this.getIdentity() + ", origins=" + this.getOrigins() + ", credentialRepository=" + this.getCredentialRepository() + ", appId=" + this.getAppId() + ", attestationConveyancePreference=" + this.getAttestationConveyancePreference() + ", metadataService=" + this.getMetadataService() + ", preferredPubkeyParams=" + this.getPreferredPubkeyParams() + ", allowUnrequestedExtensions=" + this.isAllowUnrequestedExtensions() + ", allowUntrustedAttestation=" + this.isAllowUntrustedAttestation() + ", validateSignatureCounter=" + this.isValidateSignatureCounter() + ")";
    }

    public static class RelyingPartyBuilder {
        @Generated
        private RelyingPartyIdentity identity;
        @Generated
        private Set<String> origins;
        @Generated
        private CredentialRepository credentialRepository;
        @Generated
        private boolean preferredPubkeyParams$set;
        @Generated
        private List<PublicKeyCredentialParameters> preferredPubkeyParams;
        @Generated
        private boolean allowUnrequestedExtensions$set;
        @Generated
        private boolean allowUnrequestedExtensions;
        @Generated
        private boolean allowUntrustedAttestation$set;
        @Generated
        private boolean allowUntrustedAttestation;
        @Generated
        private boolean validateSignatureCounter$set;
        @Generated
        private boolean validateSignatureCounter;
        @NonNull
        private Optional<AppId> appId = Optional.empty();
        @NonNull
        private Optional<AttestationConveyancePreference> attestationConveyancePreference = Optional.empty();
        @NonNull
        private Optional<MetadataService> metadataService = Optional.empty();

        public RelyingPartyBuilder appId(@NonNull Optional<AppId> appId) {
            if (appId == null) {
                throw new NullPointerException("appId is marked @NonNull but is null");
            }
            this.appId = appId;
            return this;
        }

        public RelyingPartyBuilder appId(@NonNull AppId appId) {
            if (appId == null) {
                throw new NullPointerException("appId is marked @NonNull but is null");
            }
            return this.appId(Optional.of(appId));
        }

        public RelyingPartyBuilder attestationConveyancePreference(@NonNull Optional<AttestationConveyancePreference> attestationConveyancePreference) {
            if (attestationConveyancePreference == null) {
                throw new NullPointerException("attestationConveyancePreference is marked @NonNull but is null");
            }
            this.attestationConveyancePreference = attestationConveyancePreference;
            return this;
        }

        public RelyingPartyBuilder attestationConveyancePreference(@NonNull AttestationConveyancePreference attestationConveyancePreference) {
            if (attestationConveyancePreference == null) {
                throw new NullPointerException("attestationConveyancePreference is marked @NonNull but is null");
            }
            return this.attestationConveyancePreference(Optional.of(attestationConveyancePreference));
        }

        public RelyingPartyBuilder metadataService(@NonNull Optional<MetadataService> metadataService) {
            if (metadataService == null) {
                throw new NullPointerException("metadataService is marked @NonNull but is null");
            }
            this.metadataService = metadataService;
            return this;
        }

        public RelyingPartyBuilder metadataService(@NonNull MetadataService metadataService) {
            if (metadataService == null) {
                throw new NullPointerException("metadataService is marked @NonNull but is null");
            }
            return this.metadataService(Optional.of(metadataService));
        }

        @Generated
        RelyingPartyBuilder() {
        }

        @Generated
        public RelyingPartyBuilder identity(@NonNull RelyingPartyIdentity identity) {
            if (identity == null) {
                throw new NullPointerException("identity is marked @NonNull but is null");
            }
            this.identity = identity;
            return this;
        }

        @Generated
        public RelyingPartyBuilder origins(@NonNull Set<String> origins) {
            if (origins == null) {
                throw new NullPointerException("origins is marked @NonNull but is null");
            }
            this.origins = origins;
            return this;
        }

        @Generated
        public RelyingPartyBuilder credentialRepository(@NonNull CredentialRepository credentialRepository) {
            if (credentialRepository == null) {
                throw new NullPointerException("credentialRepository is marked @NonNull but is null");
            }
            this.credentialRepository = credentialRepository;
            return this;
        }

        @Generated
        public RelyingPartyBuilder preferredPubkeyParams(@NonNull List<PublicKeyCredentialParameters> preferredPubkeyParams) {
            if (preferredPubkeyParams == null) {
                throw new NullPointerException("preferredPubkeyParams is marked @NonNull but is null");
            }
            this.preferredPubkeyParams = preferredPubkeyParams;
            this.preferredPubkeyParams$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder allowUnrequestedExtensions(boolean allowUnrequestedExtensions) {
            this.allowUnrequestedExtensions = allowUnrequestedExtensions;
            this.allowUnrequestedExtensions$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder allowUntrustedAttestation(boolean allowUntrustedAttestation) {
            this.allowUntrustedAttestation = allowUntrustedAttestation;
            this.allowUntrustedAttestation$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder validateSignatureCounter(boolean validateSignatureCounter) {
            this.validateSignatureCounter = validateSignatureCounter;
            this.validateSignatureCounter$set = true;
            return this;
        }

        @Generated
        public RelyingParty build() {
            List preferredPubkeyParams = this.preferredPubkeyParams;
            if (!this.preferredPubkeyParams$set) {
                preferredPubkeyParams = RelyingParty.$default$preferredPubkeyParams();
            }
            boolean allowUnrequestedExtensions = this.allowUnrequestedExtensions;
            if (!this.allowUnrequestedExtensions$set) {
                allowUnrequestedExtensions = RelyingParty.$default$allowUnrequestedExtensions();
            }
            boolean allowUntrustedAttestation = this.allowUntrustedAttestation;
            if (!this.allowUntrustedAttestation$set) {
                allowUntrustedAttestation = RelyingParty.$default$allowUntrustedAttestation();
            }
            boolean validateSignatureCounter = this.validateSignatureCounter;
            if (!this.validateSignatureCounter$set) {
                validateSignatureCounter = RelyingParty.$default$validateSignatureCounter();
            }
            return new RelyingParty(this.identity, this.origins, this.credentialRepository, this.appId, this.attestationConveyancePreference, this.metadataService, preferredPubkeyParams, allowUnrequestedExtensions, allowUntrustedAttestation, validateSignatureCounter);
        }

        @Generated
        public String toString() {
            return "RelyingParty.RelyingPartyBuilder(identity=" + this.identity + ", origins=" + this.origins + ", credentialRepository=" + this.credentialRepository + ", appId=" + this.appId + ", attestationConveyancePreference=" + this.attestationConveyancePreference + ", metadataService=" + this.metadataService + ", preferredPubkeyParams=" + this.preferredPubkeyParams + ", allowUnrequestedExtensions=" + this.allowUnrequestedExtensions + ", allowUntrustedAttestation=" + this.allowUntrustedAttestation + ", validateSignatureCounter=" + this.validateSignatureCounter + ")";
        }

        public static class MandatoryStages {
            private final RelyingPartyBuilder builder = new RelyingPartyBuilder();

            public Step2 identity(RelyingPartyIdentity identity) {
                this.builder.identity(identity);
                return new Step2();
            }

            public class Step2 {
                public RelyingPartyBuilder credentialRepository(CredentialRepository credentialRepository) {
                    return MandatoryStages.this.builder.credentialRepository(credentialRepository);
                }
            }
        }
    }
}

