/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.extension.appid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.net.InetAddresses;
import com.yubico.webauthn.extension.appid.InvalidAppIdException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;

@JsonSerialize(using=JsonSerializer.class)
public final class AppId {
    private final String id;

    @JsonCreator
    public AppId(String appId) throws InvalidAppIdException {
        AppId.checkIsValid(appId);
        this.id = appId;
    }

    private static void checkIsValid(String appId) throws InvalidAppIdException {
        if (!appId.contains(":")) {
            throw new InvalidAppIdException("App ID does not look like a valid facet or URL. Web facets must start with 'https://'.");
        }
        if (appId.startsWith("http:")) {
            throw new InvalidAppIdException("HTTP is not supported for App IDs (by Chrome). Use HTTPS instead.");
        }
        if (appId.startsWith("https://")) {
            URI url = AppId.checkValidUrl(appId);
            AppId.checkPathIsNotSlash(url);
            AppId.checkNotIpAddress(url);
        }
    }

    private static void checkPathIsNotSlash(URI url) throws InvalidAppIdException {
        if ("/".equals(url.getPath())) {
            throw new InvalidAppIdException("The path of the URL set as App ID is '/'. This is probably not what you want -- remove the trailing slash of the App ID URL.");
        }
    }

    private static URI checkValidUrl(String appId) throws InvalidAppIdException {
        try {
            return new URI(appId);
        }
        catch (URISyntaxException e) {
            throw new InvalidAppIdException("App ID looks like a HTTPS URL, but has syntax errors.", e);
        }
    }

    private static void checkNotIpAddress(URI url) throws InvalidAppIdException {
        if (InetAddresses.isInetAddress((String)url.getAuthority()) || url.getHost() != null && InetAddresses.isInetAddress((String)url.getHost())) {
            throw new InvalidAppIdException("App ID must not be an IP-address, since it is not supported (by Chrome). Use a host name instead.");
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppId)) {
            return false;
        }
        AppId other = (AppId)o;
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AppId(id=" + this.getId() + ")";
    }

    static class JsonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<AppId> {
        JsonSerializer() {
        }

        public void serialize(AppId value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getId());
        }
    }
}

