/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.AttestationStatementVerifier;
import com.yubico.webauthn.BouncyCastleCrypto;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.X5cAttestationStatementVerifier;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.exception.Base64UrlException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AndroidSafetynetAttestationStatementVerifier
implements AttestationStatementVerifier,
X5cAttestationStatementVerifier {
    private static final Logger log = LoggerFactory.getLogger(AndroidSafetynetAttestationStatementVerifier.class);
    private final BouncyCastleCrypto crypto = new BouncyCastleCrypto();
    private static final DefaultHostnameVerifier HOSTNAME_VERIFIER = new DefaultHostnameVerifier();

    AndroidSafetynetAttestationStatementVerifier() {
    }

    @Override
    public AttestationType getAttestationType(AttestationObject attestation) {
        return AttestationType.BASIC;
    }

    @Override
    public JsonNode getX5cArray(AttestationObject attestationObject) {
        JsonNodeFactory jsonFactory = JsonNodeFactory.instance;
        ArrayNode array = jsonFactory.arrayNode();
        for (JsonNode cert : AndroidSafetynetAttestationStatementVerifier.parseJws(attestationObject).getHeader().get("x5c")) {
            array.add((JsonNode)jsonFactory.binaryNode(ByteArray.fromBase64(cert.textValue()).getBytes()));
        }
        return array;
    }

    @Override
    public boolean verifyAttestationSignature(AttestationObject attestationObject, ByteArray clientDataJsonHash) {
        JsonNode ver = attestationObject.getAttestationStatement().get("ver");
        if (ver == null || !ver.isTextual()) {
            throw new IllegalArgumentException("Property \"ver\" of android-safetynet attestation statement must be a string, was: " + ver);
        }
        JsonWebSignatureCustom jws = AndroidSafetynetAttestationStatementVerifier.parseJws(attestationObject);
        if (!this.verifySignature(jws)) {
            return false;
        }
        JsonNode payload = jws.getPayload();
        ByteArray signedData = attestationObject.getAuthenticatorData().getBytes().concat(clientDataJsonHash);
        ByteArray hashSignedData = this.crypto.hash(signedData);
        ByteArray nonceByteArray = ByteArray.fromBase64(payload.get("nonce").textValue());
        ExceptionUtil.assure((boolean)hashSignedData.equals(nonceByteArray), (String)"Nonce does not equal authenticator data + client data. Expected nonce: %s, was nonce: %s", (Object[])new Object[]{hashSignedData.getBase64Url(), nonceByteArray.getBase64Url()});
        ExceptionUtil.assure((boolean)payload.get("ctsProfileMatch").booleanValue(), (String)"Expected ctsProfileMatch to be true, was: %s", (Object[])new Object[]{payload.get("ctsProfileMatch")});
        return true;
    }

    private static JsonWebSignatureCustom parseJws(AttestationObject attestationObject) {
        return new JsonWebSignatureCustom(new String(AndroidSafetynetAttestationStatementVerifier.getResponseBytes(attestationObject).getBytes(), StandardCharsets.UTF_8));
    }

    private static ByteArray getResponseBytes(AttestationObject attestationObject) {
        JsonNode response = attestationObject.getAttestationStatement().get("response");
        if (response == null || !response.isBinary()) {
            throw new IllegalArgumentException("Property \"response\" of android-safetynet attestation statement must be a binary value, was: " + response);
        }
        try {
            return new ByteArray(response.binaryValue());
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrapAndLog((Logger)log, (String)("response.isBinary() was true but response.binaryValue failed: " + response), (Throwable)ioe);
        }
    }

    private boolean verifySignature(JsonWebSignatureCustom jws) {
        Signature signatureVerifier;
        X509Certificate attestationCertificate = jws.getX5c().get(0);
        String signatureAlgorithmName = WebAuthnCodecs.jwsAlgorithmNameToJavaAlgorithmName(jws.getAlgorithm());
        try {
            signatureVerifier = Signature.getInstance(signatureAlgorithmName, this.crypto.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw ExceptionUtil.wrapAndLog((Logger)log, (String)("Failed to get a Signature instance for " + signatureAlgorithmName), (Throwable)e);
        }
        try {
            signatureVerifier.initVerify(attestationCertificate.getPublicKey());
        }
        catch (InvalidKeyException e) {
            throw ExceptionUtil.wrapAndLog((Logger)log, (String)("Attestation key is invalid: " + attestationCertificate), (Throwable)e);
        }
        try {
            signatureVerifier.update(jws.getSignedBytes().getBytes());
        }
        catch (SignatureException e) {
            throw ExceptionUtil.wrapAndLog((Logger)log, (String)("Signature object in invalid state: " + signatureVerifier), (Throwable)e);
        }
        ExceptionUtil.assure((boolean)AndroidSafetynetAttestationStatementVerifier.verifyHostname(attestationCertificate), (String)"Certificate isn't issued for the hostname attest.android.com: %s", (Object[])new Object[]{attestationCertificate});
        try {
            return signatureVerifier.verify(jws.getSignature().getBytes());
        }
        catch (SignatureException e) {
            throw ExceptionUtil.wrapAndLog((Logger)log, (String)("Failed to verify signature of JWS: " + jws), (Throwable)e);
        }
    }

    private static boolean verifyHostname(X509Certificate leafCert) {
        try {
            HOSTNAME_VERIFIER.verify("attest.android.com", leafCert);
            return true;
        }
        catch (SSLException e) {
            return false;
        }
    }

    private static final class JsonWebSignatureCustom {
        public final JsonNode header;
        public final JsonNode payload;
        public final ByteArray signedBytes;
        public final ByteArray signature;
        public final List<X509Certificate> x5c;
        public final String algorithm;

        JsonWebSignatureCustom(String jwsCompact) {
            String[] parts = jwsCompact.split("\\.");
            ObjectMapper json = JacksonCodecs.json();
            try {
                ByteArray header = ByteArray.fromBase64Url(parts[0]);
                ByteArray payload = ByteArray.fromBase64Url(parts[1]);
                this.header = json.readTree(header.getBytes());
                this.payload = json.readTree(payload.getBytes());
                this.signedBytes = new ByteArray((parts[0] + "." + parts[1]).getBytes(StandardCharsets.UTF_8));
                this.signature = ByteArray.fromBase64Url(parts[2]);
                this.x5c = JsonWebSignatureCustom.getX5c(this.header);
                this.algorithm = this.header.get("alg").textValue();
            }
            catch (Base64UrlException | IOException e) {
                throw ExceptionUtil.wrapAndLog((Logger)log, (String)("Failed to parse JWS: " + jwsCompact), (Throwable)e);
            }
            catch (CertificateException e) {
                throw ExceptionUtil.wrapAndLog((Logger)log, (String)("Failed to parse attestation certificates in JWS header: " + jwsCompact), (Throwable)e);
            }
        }

        private static List<X509Certificate> getX5c(JsonNode header) throws IOException, CertificateException {
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            for (JsonNode jsonNode : header.get("x5c")) {
                result.add(CertificateParser.parseDer((byte[])jsonNode.binaryValue()));
            }
            return result;
        }

        public JsonNode getHeader() {
            return this.header;
        }

        public JsonNode getPayload() {
            return this.payload;
        }

        public ByteArray getSignedBytes() {
            return this.signedBytes;
        }

        public ByteArray getSignature() {
            return this.signature;
        }

        public List<X509Certificate> getX5c() {
            return this.x5c;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonWebSignatureCustom)) {
                return false;
            }
            JsonWebSignatureCustom other = (JsonWebSignatureCustom)o;
            JsonNode this$header = this.getHeader();
            JsonNode other$header = other.getHeader();
            if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
                return false;
            }
            JsonNode this$payload = this.getPayload();
            JsonNode other$payload = other.getPayload();
            if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
                return false;
            }
            ByteArray this$signedBytes = this.getSignedBytes();
            ByteArray other$signedBytes = other.getSignedBytes();
            if (this$signedBytes == null ? other$signedBytes != null : !((Object)this$signedBytes).equals(other$signedBytes)) {
                return false;
            }
            ByteArray this$signature = this.getSignature();
            ByteArray other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
                return false;
            }
            List<X509Certificate> this$x5c = this.getX5c();
            List<X509Certificate> other$x5c = other.getX5c();
            if (this$x5c == null ? other$x5c != null : !((Object)this$x5c).equals(other$x5c)) {
                return false;
            }
            String this$algorithm = this.getAlgorithm();
            String other$algorithm = other.getAlgorithm();
            return !(this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JsonNode $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            JsonNode $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            ByteArray $signedBytes = this.getSignedBytes();
            result = result * 59 + ($signedBytes == null ? 43 : ((Object)$signedBytes).hashCode());
            ByteArray $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
            List<X509Certificate> $x5c = this.getX5c();
            result = result * 59 + ($x5c == null ? 43 : ((Object)$x5c).hashCode());
            String $algorithm = this.getAlgorithm();
            result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
            return result;
        }

        public String toString() {
            return "AndroidSafetynetAttestationStatementVerifier.JsonWebSignatureCustom(header=" + this.getHeader() + ", payload=" + this.getPayload() + ", signedBytes=" + this.getSignedBytes() + ", signature=" + this.getSignature() + ", x5c=" + this.getX5c() + ", algorithm=" + this.getAlgorithm() + ")";
        }
    }
}

