/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.AttestationTrustResolver;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.MetadataService;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KnownX509TrustAnchorsTrustResolver
implements AttestationTrustResolver {
    private static final Logger log = LoggerFactory.getLogger(KnownX509TrustAnchorsTrustResolver.class);
    private final MetadataService metadataService;

    @Override
    public Attestation resolveTrustAnchor(List<X509Certificate> certificateChain) throws CertificateEncodingException {
        return this.metadataService.getAttestation(certificateChain);
    }

    public KnownX509TrustAnchorsTrustResolver(MetadataService metadataService) {
        this.metadataService = metadataService;
    }
}

