/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.data.ByteArray;
import lombok.NonNull;

public final class RegisteredCredential {
    @NonNull
    private final ByteArray credentialId;
    @NonNull
    private final ByteArray userHandle;
    @NonNull
    private final ByteArray publicKeyCose;
    private final long signatureCount;

    public static RegisteredCredentialBuilder.MandatoryStages builder() {
        return new RegisteredCredentialBuilder.MandatoryStages();
    }

    private static long $default$signatureCount() {
        return 0L;
    }

    public RegisteredCredentialBuilder toBuilder() {
        return new RegisteredCredentialBuilder().credentialId(this.credentialId).userHandle(this.userHandle).publicKeyCose(this.publicKeyCose).signatureCount(this.signatureCount);
    }

    @NonNull
    public ByteArray getCredentialId() {
        return this.credentialId;
    }

    @NonNull
    public ByteArray getUserHandle() {
        return this.userHandle;
    }

    @NonNull
    public ByteArray getPublicKeyCose() {
        return this.publicKeyCose;
    }

    public long getSignatureCount() {
        return this.signatureCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredCredential)) {
            return false;
        }
        RegisteredCredential other = (RegisteredCredential)o;
        ByteArray this$credentialId = this.getCredentialId();
        ByteArray other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId)) {
            return false;
        }
        ByteArray this$userHandle = this.getUserHandle();
        ByteArray other$userHandle = other.getUserHandle();
        if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
            return false;
        }
        ByteArray this$publicKeyCose = this.getPublicKeyCose();
        ByteArray other$publicKeyCose = other.getPublicKeyCose();
        if (this$publicKeyCose == null ? other$publicKeyCose != null : !((Object)this$publicKeyCose).equals(other$publicKeyCose)) {
            return false;
        }
        return this.getSignatureCount() == other.getSignatureCount();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        ByteArray $userHandle = this.getUserHandle();
        result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
        ByteArray $publicKeyCose = this.getPublicKeyCose();
        result = result * 59 + ($publicKeyCose == null ? 43 : ((Object)$publicKeyCose).hashCode());
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        return result;
    }

    public String toString() {
        return "RegisteredCredential(credentialId=" + this.getCredentialId() + ", userHandle=" + this.getUserHandle() + ", publicKeyCose=" + this.getPublicKeyCose() + ", signatureCount=" + this.getSignatureCount() + ")";
    }

    private RegisteredCredential(@NonNull ByteArray credentialId, @NonNull ByteArray userHandle, @NonNull ByteArray publicKeyCose, long signatureCount) {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        this.credentialId = credentialId;
        this.userHandle = userHandle;
        this.publicKeyCose = publicKeyCose;
        this.signatureCount = signatureCount;
    }

    public static class RegisteredCredentialBuilder {
        private ByteArray credentialId;
        private ByteArray userHandle;
        private ByteArray publicKeyCose;
        private boolean signatureCount$set;
        private long signatureCount;

        RegisteredCredentialBuilder() {
        }

        public RegisteredCredentialBuilder credentialId(@NonNull ByteArray credentialId) {
            if (credentialId == null) {
                throw new NullPointerException("credentialId is marked non-null but is null");
            }
            this.credentialId = credentialId;
            return this;
        }

        public RegisteredCredentialBuilder userHandle(@NonNull ByteArray userHandle) {
            if (userHandle == null) {
                throw new NullPointerException("userHandle is marked non-null but is null");
            }
            this.userHandle = userHandle;
            return this;
        }

        public RegisteredCredentialBuilder publicKeyCose(@NonNull ByteArray publicKeyCose) {
            if (publicKeyCose == null) {
                throw new NullPointerException("publicKeyCose is marked non-null but is null");
            }
            this.publicKeyCose = publicKeyCose;
            return this;
        }

        public RegisteredCredentialBuilder signatureCount(long signatureCount) {
            this.signatureCount = signatureCount;
            this.signatureCount$set = true;
            return this;
        }

        public RegisteredCredential build() {
            long signatureCount = this.signatureCount;
            if (!this.signatureCount$set) {
                signatureCount = RegisteredCredential.$default$signatureCount();
            }
            return new RegisteredCredential(this.credentialId, this.userHandle, this.publicKeyCose, signatureCount);
        }

        public String toString() {
            return "RegisteredCredential.RegisteredCredentialBuilder(credentialId=" + this.credentialId + ", userHandle=" + this.userHandle + ", publicKeyCose=" + this.publicKeyCose + ", signatureCount=" + this.signatureCount + ")";
        }

        public static class MandatoryStages {
            private RegisteredCredentialBuilder builder = new RegisteredCredentialBuilder();

            public Step2 credentialId(ByteArray credentialId) {
                this.builder.credentialId(credentialId);
                return new Step2();
            }

            public class Step3 {
                public RegisteredCredentialBuilder publicKeyCose(ByteArray publicKeyCose) {
                    return MandatoryStages.this.builder.publicKeyCose(publicKeyCose);
                }
            }

            public class Step2 {
                public Step3 userHandle(ByteArray userHandle) {
                    MandatoryStages.this.builder.userHandle(userHandle);
                    return new Step3();
                }
            }
        }
    }
}

