/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.RegistrationExtensionInputs;
import com.yubico.webauthn.data.UserIdentity;
import java.util.Optional;
import lombok.NonNull;

public final class StartRegistrationOptions {
    @NonNull
    private final UserIdentity user;
    private final AuthenticatorSelectionCriteria authenticatorSelection;
    @NonNull
    private final RegistrationExtensionInputs extensions;
    private final Long timeout;

    public Optional<AuthenticatorSelectionCriteria> getAuthenticatorSelection() {
        return Optional.ofNullable(this.authenticatorSelection);
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public static StartRegistrationOptionsBuilder.MandatoryStages builder() {
        return new StartRegistrationOptionsBuilder.MandatoryStages();
    }

    private static RegistrationExtensionInputs $default$extensions() {
        return RegistrationExtensionInputs.builder().build();
    }

    StartRegistrationOptions(@NonNull UserIdentity user, AuthenticatorSelectionCriteria authenticatorSelection, @NonNull RegistrationExtensionInputs extensions, Long timeout) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions is marked non-null but is null");
        }
        this.user = user;
        this.authenticatorSelection = authenticatorSelection;
        this.extensions = extensions;
        this.timeout = timeout;
    }

    public StartRegistrationOptionsBuilder toBuilder() {
        return new StartRegistrationOptionsBuilder().user(this.user).authenticatorSelection(this.authenticatorSelection).extensions(this.extensions).timeout(this.timeout);
    }

    @NonNull
    public UserIdentity getUser() {
        return this.user;
    }

    @NonNull
    public RegistrationExtensionInputs getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartRegistrationOptions)) {
            return false;
        }
        StartRegistrationOptions other = (StartRegistrationOptions)o;
        UserIdentity this$user = this.getUser();
        UserIdentity other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Optional<AuthenticatorSelectionCriteria> this$authenticatorSelection = this.getAuthenticatorSelection();
        Optional<AuthenticatorSelectionCriteria> other$authenticatorSelection = other.getAuthenticatorSelection();
        if (this$authenticatorSelection == null ? other$authenticatorSelection != null : !((Object)this$authenticatorSelection).equals(other$authenticatorSelection)) {
            return false;
        }
        RegistrationExtensionInputs this$extensions = this.getExtensions();
        RegistrationExtensionInputs other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        Optional<Long> this$timeout = this.getTimeout();
        Optional<Long> other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserIdentity $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Optional<AuthenticatorSelectionCriteria> $authenticatorSelection = this.getAuthenticatorSelection();
        result = result * 59 + ($authenticatorSelection == null ? 43 : ((Object)$authenticatorSelection).hashCode());
        RegistrationExtensionInputs $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        Optional<Long> $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    public String toString() {
        return "StartRegistrationOptions(user=" + this.getUser() + ", authenticatorSelection=" + this.getAuthenticatorSelection() + ", extensions=" + this.getExtensions() + ", timeout=" + this.getTimeout() + ")";
    }

    public static class StartRegistrationOptionsBuilder {
        private UserIdentity user;
        private boolean extensions$set;
        private RegistrationExtensionInputs extensions;
        private AuthenticatorSelectionCriteria authenticatorSelection = null;
        private Long timeout = null;

        public StartRegistrationOptionsBuilder authenticatorSelection(@NonNull Optional<AuthenticatorSelectionCriteria> authenticatorSelection) {
            if (authenticatorSelection == null) {
                throw new NullPointerException("authenticatorSelection is marked non-null but is null");
            }
            return this.authenticatorSelection((AuthenticatorSelectionCriteria)authenticatorSelection.orElse(null));
        }

        public StartRegistrationOptionsBuilder authenticatorSelection(AuthenticatorSelectionCriteria authenticatorSelection) {
            this.authenticatorSelection = authenticatorSelection;
            return this;
        }

        public StartRegistrationOptionsBuilder timeout(@NonNull Optional<Long> timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            if (timeout.isPresent() && timeout.get() <= 0L) {
                throw new IllegalArgumentException("timeout must be positive, was: " + timeout.get());
            }
            this.timeout = timeout.orElse(null);
            return this;
        }

        public StartRegistrationOptionsBuilder timeout(long timeout) {
            return this.timeout(Optional.of(timeout));
        }

        StartRegistrationOptionsBuilder() {
        }

        public StartRegistrationOptionsBuilder user(@NonNull UserIdentity user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
            return this;
        }

        public StartRegistrationOptionsBuilder extensions(@NonNull RegistrationExtensionInputs extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions is marked non-null but is null");
            }
            this.extensions = extensions;
            this.extensions$set = true;
            return this;
        }

        public StartRegistrationOptions build() {
            RegistrationExtensionInputs extensions = this.extensions;
            if (!this.extensions$set) {
                extensions = StartRegistrationOptions.$default$extensions();
            }
            return new StartRegistrationOptions(this.user, this.authenticatorSelection, extensions, this.timeout);
        }

        public String toString() {
            return "StartRegistrationOptions.StartRegistrationOptionsBuilder(user=" + this.user + ", authenticatorSelection=" + this.authenticatorSelection + ", extensions=" + this.extensions + ", timeout=" + this.timeout + ")";
        }

        public static class MandatoryStages {
            private final StartRegistrationOptionsBuilder builder = new StartRegistrationOptionsBuilder();

            public StartRegistrationOptionsBuilder user(UserIdentity user) {
                return this.builder.user(user);
            }
        }
    }
}

