/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.yubico.webauthn.BouncyCastleCrypto;
import com.yubico.webauthn.data.ByteArray;
import java.security.cert.X509Certificate;

final class U2fRawRegisterResponse {
    private static final byte REGISTRATION_SIGNED_RESERVED_BYTE_VALUE = 0;
    private static final BouncyCastleCrypto crypto = new BouncyCastleCrypto();
    private final ByteArray userPublicKey;
    private final ByteArray keyHandle;
    private final X509Certificate attestationCertificate;
    private final ByteArray signature;

    U2fRawRegisterResponse(ByteArray userPublicKey, ByteArray keyHandle, X509Certificate attestationCertificate, ByteArray signature) {
        this.userPublicKey = userPublicKey;
        this.keyHandle = keyHandle;
        this.attestationCertificate = attestationCertificate;
        this.signature = signature;
    }

    boolean verifySignature(ByteArray appIdHash, ByteArray clientDataHash) {
        ByteArray signedBytes = U2fRawRegisterResponse.packBytesToSign(appIdHash, clientDataHash, this.keyHandle, this.userPublicKey);
        return crypto.verifySignature(this.attestationCertificate, signedBytes, this.signature);
    }

    private static ByteArray packBytesToSign(ByteArray appIdHash, ByteArray clientDataHash, ByteArray keyHandle, ByteArray userPublicKey) {
        ByteArrayDataOutput encoded = ByteStreams.newDataOutput();
        encoded.write(0);
        encoded.write(appIdHash.getBytes());
        encoded.write(clientDataHash.getBytes());
        encoded.write(keyHandle.getBytes());
        encoded.write(userPublicKey.getBytes());
        return new ByteArray(encoded.toByteArray());
    }

    public ByteArray getUserPublicKey() {
        return this.userPublicKey;
    }

    public ByteArray getKeyHandle() {
        return this.keyHandle;
    }

    public X509Certificate getAttestationCertificate() {
        return this.attestationCertificate;
    }

    public ByteArray getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof U2fRawRegisterResponse)) {
            return false;
        }
        U2fRawRegisterResponse other = (U2fRawRegisterResponse)o;
        ByteArray this$userPublicKey = this.getUserPublicKey();
        ByteArray other$userPublicKey = other.getUserPublicKey();
        if (this$userPublicKey == null ? other$userPublicKey != null : !((Object)this$userPublicKey).equals(other$userPublicKey)) {
            return false;
        }
        ByteArray this$keyHandle = this.getKeyHandle();
        ByteArray other$keyHandle = other.getKeyHandle();
        if (this$keyHandle == null ? other$keyHandle != null : !((Object)this$keyHandle).equals(other$keyHandle)) {
            return false;
        }
        X509Certificate this$attestationCertificate = this.getAttestationCertificate();
        X509Certificate other$attestationCertificate = other.getAttestationCertificate();
        if (this$attestationCertificate == null ? other$attestationCertificate != null : !((Object)this$attestationCertificate).equals(other$attestationCertificate)) {
            return false;
        }
        ByteArray this$signature = this.getSignature();
        ByteArray other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $userPublicKey = this.getUserPublicKey();
        result = result * 59 + ($userPublicKey == null ? 43 : ((Object)$userPublicKey).hashCode());
        ByteArray $keyHandle = this.getKeyHandle();
        result = result * 59 + ($keyHandle == null ? 43 : ((Object)$keyHandle).hashCode());
        X509Certificate $attestationCertificate = this.getAttestationCertificate();
        result = result * 59 + ($attestationCertificate == null ? 43 : ((Object)$attestationCertificate).hashCode());
        ByteArray $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    public String toString() {
        return "U2fRawRegisterResponse(userPublicKey=" + this.getUserPublicKey() + ", keyHandle=" + this.getKeyHandle() + ", attestationCertificate=" + this.getAttestationCertificate() + ", signature=" + this.getSignature() + ")";
    }
}

