/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.AuthenticatorResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.CollectedClientData;
import com.yubico.webauthn.data.exception.Base64UrlException;
import java.io.IOException;
import java.util.Optional;
import lombok.NonNull;

public final class AuthenticatorAssertionResponse
implements AuthenticatorResponse {
    @NonNull
    private final ByteArray authenticatorData;
    @NonNull
    private final ByteArray clientDataJSON;
    @NonNull
    private final ByteArray signature;
    private final ByteArray userHandle;
    @NonNull
    private final transient CollectedClientData clientData;

    @JsonCreator
    private AuthenticatorAssertionResponse(@JsonProperty(value="authenticatorData") @NonNull ByteArray authenticatorData, @JsonProperty(value="clientDataJSON") @NonNull ByteArray clientDataJSON, @JsonProperty(value="signature") @NonNull ByteArray signature, @JsonProperty(value="userHandle") ByteArray userHandle) throws IOException, Base64UrlException {
        if (authenticatorData == null) {
            throw new NullPointerException("authenticatorData is marked non-null but is null");
        }
        if (clientDataJSON == null) {
            throw new NullPointerException("clientDataJSON is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        this.authenticatorData = authenticatorData;
        this.clientDataJSON = clientDataJSON;
        this.signature = signature;
        this.userHandle = userHandle;
        this.clientData = new CollectedClientData(this.clientDataJSON);
    }

    public Optional<ByteArray> getUserHandle() {
        return Optional.ofNullable(this.userHandle);
    }

    public static AuthenticatorAssertionResponseBuilder.MandatoryStages builder() {
        return new AuthenticatorAssertionResponseBuilder.MandatoryStages();
    }

    public AuthenticatorAssertionResponseBuilder toBuilder() {
        return new AuthenticatorAssertionResponseBuilder().authenticatorData(this.authenticatorData).clientDataJSON(this.clientDataJSON).signature(this.signature).userHandle(this.userHandle);
    }

    @NonNull
    public ByteArray getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorAssertionResponse)) {
            return false;
        }
        AuthenticatorAssertionResponse other = (AuthenticatorAssertionResponse)o;
        ByteArray this$authenticatorData = this.getAuthenticatorData();
        ByteArray other$authenticatorData = other.getAuthenticatorData();
        if (this$authenticatorData == null ? other$authenticatorData != null : !((Object)this$authenticatorData).equals(other$authenticatorData)) {
            return false;
        }
        ByteArray this$clientDataJSON = this.getClientDataJSON();
        ByteArray other$clientDataJSON = other.getClientDataJSON();
        if (this$clientDataJSON == null ? other$clientDataJSON != null : !((Object)this$clientDataJSON).equals(other$clientDataJSON)) {
            return false;
        }
        ByteArray this$signature = this.getSignature();
        ByteArray other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        Optional<ByteArray> this$userHandle = this.getUserHandle();
        Optional<ByteArray> other$userHandle = other.getUserHandle();
        return !(this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $authenticatorData = this.getAuthenticatorData();
        result = result * 59 + ($authenticatorData == null ? 43 : ((Object)$authenticatorData).hashCode());
        ByteArray $clientDataJSON = this.getClientDataJSON();
        result = result * 59 + ($clientDataJSON == null ? 43 : ((Object)$clientDataJSON).hashCode());
        ByteArray $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        Optional<ByteArray> $userHandle = this.getUserHandle();
        result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticatorAssertionResponse(authenticatorData=" + this.getAuthenticatorData() + ", clientDataJSON=" + this.getClientDataJSON() + ", signature=" + this.getSignature() + ", userHandle=" + this.getUserHandle() + ", clientData=" + this.getClientData() + ")";
    }

    @Override
    @NonNull
    public ByteArray getAuthenticatorData() {
        return this.authenticatorData;
    }

    @Override
    @NonNull
    public ByteArray getClientDataJSON() {
        return this.clientDataJSON;
    }

    @Override
    @NonNull
    public CollectedClientData getClientData() {
        return this.clientData;
    }

    public static class AuthenticatorAssertionResponseBuilder {
        private ByteArray authenticatorData;
        private ByteArray clientDataJSON;
        private ByteArray signature;
        private ByteArray userHandle = null;

        public AuthenticatorAssertionResponseBuilder userHandle(@NonNull Optional<ByteArray> userHandle) {
            if (userHandle == null) {
                throw new NullPointerException("userHandle is marked non-null but is null");
            }
            return this.userHandle((ByteArray)userHandle.orElse(null));
        }

        public AuthenticatorAssertionResponseBuilder userHandle(ByteArray userHandle) {
            this.userHandle = userHandle;
            return this;
        }

        AuthenticatorAssertionResponseBuilder() {
        }

        @JsonProperty(value="authenticatorData")
        public AuthenticatorAssertionResponseBuilder authenticatorData(@NonNull ByteArray authenticatorData) {
            if (authenticatorData == null) {
                throw new NullPointerException("authenticatorData is marked non-null but is null");
            }
            this.authenticatorData = authenticatorData;
            return this;
        }

        @JsonProperty(value="clientDataJSON")
        public AuthenticatorAssertionResponseBuilder clientDataJSON(@NonNull ByteArray clientDataJSON) {
            if (clientDataJSON == null) {
                throw new NullPointerException("clientDataJSON is marked non-null but is null");
            }
            this.clientDataJSON = clientDataJSON;
            return this;
        }

        @JsonProperty(value="signature")
        public AuthenticatorAssertionResponseBuilder signature(@NonNull ByteArray signature) {
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            this.signature = signature;
            return this;
        }

        public AuthenticatorAssertionResponse build() throws IOException, Base64UrlException {
            return new AuthenticatorAssertionResponse(this.authenticatorData, this.clientDataJSON, this.signature, this.userHandle);
        }

        public String toString() {
            return "AuthenticatorAssertionResponse.AuthenticatorAssertionResponseBuilder(authenticatorData=" + this.authenticatorData + ", clientDataJSON=" + this.clientDataJSON + ", signature=" + this.signature + ", userHandle=" + this.userHandle + ")";
        }

        public static class MandatoryStages {
            private final AuthenticatorAssertionResponseBuilder builder = new AuthenticatorAssertionResponseBuilder();

            public Step2 authenticatorData(ByteArray authenticatorData) {
                this.builder.authenticatorData(authenticatorData);
                return new Step2();
            }

            public class Step3 {
                public AuthenticatorAssertionResponseBuilder signature(ByteArray signature) {
                    return MandatoryStages.this.builder.signature(signature);
                }
            }

            public class Step2 {
                public Step3 clientDataJSON(ByteArray clientDataJSON) {
                    MandatoryStages.this.builder.clientDataJSON(clientDataJSON);
                    return new Step3();
                }
            }
        }
    }
}

