/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import COSE.OneKey;
import com.upokecenter.cbor.CBORObject;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;

final class WebAuthnCodecs {
    private static final ByteArray ED25519_CURVE_OID = new ByteArray(new byte[]{48, 5, 6, 3, 43, 101, 112});

    WebAuthnCodecs() {
    }

    public static ByteArray ecPublicKeyToRaw(ECPublicKey key) {
        byte[] x = key.getW().getAffineX().toByteArray();
        byte[] y = key.getW().getAffineY().toByteArray();
        byte[] xPadding = new byte[Math.max(0, 32 - x.length)];
        byte[] yPadding = new byte[Math.max(0, 32 - y.length)];
        java.util.Arrays.fill(xPadding, (byte)0);
        java.util.Arrays.fill(yPadding, (byte)0);
        return new ByteArray(Arrays.concatenate((byte[])new byte[]{4}, (byte[])Arrays.concatenate((byte[])xPadding, (byte[])java.util.Arrays.copyOfRange(x, Math.max(0, x.length - 32), x.length)), (byte[])Arrays.concatenate((byte[])yPadding, (byte[])java.util.Arrays.copyOfRange(y, Math.max(0, y.length - 32), y.length))));
    }

    public static ByteArray rawEcdaKeyToCose(ByteArray key) {
        byte[] keyBytes = key.getBytes();
        if (keyBytes.length != 64 && (keyBytes.length != 65 || keyBytes[0] != 4)) {
            throw new IllegalArgumentException(String.format("Raw key must be 64 bytes long or be 65 bytes long and start with 0x04, was %d bytes starting with %02x", keyBytes.length, keyBytes[0]));
        }
        int start = keyBytes.length == 64 ? 0 : 1;
        HashMap<Long, Object> coseKey = new HashMap<Long, Object>();
        coseKey.put(1L, 2L);
        coseKey.put(3L, COSEAlgorithmIdentifier.ES256.getId());
        coseKey.put(-1L, 1L);
        coseKey.put(-2L, java.util.Arrays.copyOfRange(keyBytes, start, start + 32));
        coseKey.put(-3L, java.util.Arrays.copyOfRange(keyBytes, start + 32, start + 64));
        return new ByteArray(CBORObject.FromObject(coseKey).EncodeToBytes());
    }

    public static ByteArray ecPublicKeyToCose(ECPublicKey key) {
        return WebAuthnCodecs.rawEcdaKeyToCose(WebAuthnCodecs.ecPublicKeyToRaw(key));
    }

    public static ByteArray eddsaPublicKeyToCose(BCEdDSAPublicKey key) {
        HashMap<Long, Object> coseKey = new HashMap<Long, Object>();
        coseKey.put(1L, 1L);
        coseKey.put(3L, COSEAlgorithmIdentifier.RS256.getId());
        coseKey.put(-1L, 6L);
        coseKey.put(-2L, key.getEncoded());
        return new ByteArray(CBORObject.FromObject(coseKey).EncodeToBytes());
    }

    public static ByteArray rsaPublicKeyToCose(RSAPublicKey key) {
        HashMap<Long, Object> coseKey = new HashMap<Long, Object>();
        coseKey.put(1L, 3L);
        coseKey.put(3L, COSEAlgorithmIdentifier.RS256.getId());
        coseKey.put(-1L, key.getModulus().toByteArray());
        coseKey.put(-2L, key.getPublicExponent().toByteArray());
        return new ByteArray(CBORObject.FromObject(coseKey).EncodeToBytes());
    }

    public static PublicKey importCosePublicKey(ByteArray key) throws CoseException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        CBORObject cose = CBORObject.DecodeFromBytes((byte[])key.getBytes());
        int kty = cose.get(CBORObject.FromObject((int)1)).AsInt32();
        switch (kty) {
            case 1: {
                return WebAuthnCodecs.importCoseEdDsaPublicKey(cose);
            }
            case 2: {
                return WebAuthnCodecs.importCoseP256PublicKey(cose);
            }
            case 3: {
                return WebAuthnCodecs.importCoseRsaPublicKey(cose);
            }
        }
        throw new IllegalArgumentException("Unsupported key type: " + kty);
    }

    private static PublicKey importCoseRsaPublicKey(CBORObject cose) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, cose.get(CBORObject.FromObject((int)-1)).GetByteString()), new BigInteger(1, cose.get(CBORObject.FromObject((int)-2)).GetByteString()));
        return KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider()).generatePublic(spec);
    }

    private static ECPublicKey importCoseP256PublicKey(CBORObject cose) throws CoseException {
        return (ECPublicKey)new OneKey(cose).AsPublicKey();
    }

    private static PublicKey importCoseEdDsaPublicKey(CBORObject cose) {
        int curveId = cose.get(CBORObject.FromObject((int)-1)).AsInt32();
        switch (curveId) {
            case 6: {
                return WebAuthnCodecs.importCoseEd25519PublicKey(cose);
            }
        }
        throw new IllegalArgumentException("Unsupported EdDSA curve: " + curveId);
    }

    private static PublicKey importCoseEd25519PublicKey(CBORObject cose) {
        ByteArray rawKey = new ByteArray(cose.get(CBORObject.FromObject((int)-2)).GetByteString());
        ByteArray x509Key = new ByteArray(new byte[]{48, (byte)(ED25519_CURVE_OID.size() + 3 + rawKey.size())}).concat(ED25519_CURVE_OID).concat(new ByteArray(new byte[]{3, (byte)(rawKey.size() + 1), 0})).concat(rawKey);
        try {
            KeyFactory kFact = KeyFactory.getInstance("EdDSA", (Provider)new BouncyCastleProvider());
            return kFact.generatePublic(new X509EncodedKeySpec(x509Key.getBytes()));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSignatureAlgorithmName(PublicKey key) {
        if (key.getAlgorithm().equals("EC")) {
            return "ECDSA";
        }
        return key.getAlgorithm();
    }

    public static String jwsAlgorithmNameToJavaAlgorithmName(String alg) {
        switch (alg) {
            case "RS256": {
                return "SHA256withRSA";
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + alg);
    }
}

