/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AuthenticatorResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.CollectedClientData;
import com.yubico.webauthn.data.exception.Base64UrlException;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;

public final class AuthenticatorAttestationResponse
implements AuthenticatorResponse {
    @NonNull
    private final ByteArray attestationObject;
    @NonNull
    private final ByteArray clientDataJSON;
    @JsonIgnore
    @NonNull
    private final transient AttestationObject attestation;
    @JsonIgnore
    @NonNull
    private final transient CollectedClientData clientData;

    @Override
    @JsonIgnore
    public ByteArray getAuthenticatorData() {
        return this.attestation.getAuthenticatorData().getBytes();
    }

    @JsonCreator
    private AuthenticatorAttestationResponse(@JsonProperty(value="attestationObject") @NonNull ByteArray attestationObject, @JsonProperty(value="clientDataJSON") @NonNull ByteArray clientDataJSON) throws IOException, Base64UrlException {
        if (attestationObject == null) {
            throw new NullPointerException("attestationObject is marked non-null but is null");
        }
        if (clientDataJSON == null) {
            throw new NullPointerException("clientDataJSON is marked non-null but is null");
        }
        this.attestationObject = attestationObject;
        this.clientDataJSON = clientDataJSON;
        this.attestation = new AttestationObject(attestationObject);
        this.clientData = new CollectedClientData(clientDataJSON);
    }

    public static AuthenticatorAttestationResponseBuilder.MandatoryStages builder() {
        return new AuthenticatorAttestationResponseBuilder.MandatoryStages();
    }

    @Generated
    public AuthenticatorAttestationResponseBuilder toBuilder() {
        return new AuthenticatorAttestationResponseBuilder().attestationObject(this.attestationObject).clientDataJSON(this.clientDataJSON);
    }

    @NonNull
    @Generated
    public ByteArray getAttestationObject() {
        return this.attestationObject;
    }

    @NonNull
    @Generated
    public AttestationObject getAttestation() {
        return this.attestation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorAttestationResponse)) {
            return false;
        }
        AuthenticatorAttestationResponse other = (AuthenticatorAttestationResponse)o;
        ByteArray this$attestationObject = this.getAttestationObject();
        ByteArray other$attestationObject = other.getAttestationObject();
        if (this$attestationObject == null ? other$attestationObject != null : !((Object)this$attestationObject).equals(other$attestationObject)) {
            return false;
        }
        ByteArray this$clientDataJSON = this.getClientDataJSON();
        ByteArray other$clientDataJSON = other.getClientDataJSON();
        return !(this$clientDataJSON == null ? other$clientDataJSON != null : !((Object)this$clientDataJSON).equals(other$clientDataJSON));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $attestationObject = this.getAttestationObject();
        result = result * 59 + ($attestationObject == null ? 43 : ((Object)$attestationObject).hashCode());
        ByteArray $clientDataJSON = this.getClientDataJSON();
        result = result * 59 + ($clientDataJSON == null ? 43 : ((Object)$clientDataJSON).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorAttestationResponse(attestationObject=" + this.getAttestationObject() + ", clientDataJSON=" + this.getClientDataJSON() + ", attestation=" + this.getAttestation() + ", clientData=" + this.getClientData() + ")";
    }

    @Override
    @NonNull
    @Generated
    public ByteArray getClientDataJSON() {
        return this.clientDataJSON;
    }

    @Override
    @NonNull
    @Generated
    public CollectedClientData getClientData() {
        return this.clientData;
    }

    public static class AuthenticatorAttestationResponseBuilder {
        @Generated
        private ByteArray attestationObject;
        @Generated
        private ByteArray clientDataJSON;

        @Generated
        AuthenticatorAttestationResponseBuilder() {
        }

        @JsonProperty(value="attestationObject")
        @Generated
        public AuthenticatorAttestationResponseBuilder attestationObject(@NonNull ByteArray attestationObject) {
            if (attestationObject == null) {
                throw new NullPointerException("attestationObject is marked non-null but is null");
            }
            this.attestationObject = attestationObject;
            return this;
        }

        @JsonProperty(value="clientDataJSON")
        @Generated
        public AuthenticatorAttestationResponseBuilder clientDataJSON(@NonNull ByteArray clientDataJSON) {
            if (clientDataJSON == null) {
                throw new NullPointerException("clientDataJSON is marked non-null but is null");
            }
            this.clientDataJSON = clientDataJSON;
            return this;
        }

        @Generated
        public AuthenticatorAttestationResponse build() throws IOException, Base64UrlException {
            return new AuthenticatorAttestationResponse(this.attestationObject, this.clientDataJSON);
        }

        @Generated
        public String toString() {
            return "AuthenticatorAttestationResponse.AuthenticatorAttestationResponseBuilder(attestationObject=" + this.attestationObject + ", clientDataJSON=" + this.clientDataJSON + ")";
        }

        public static class MandatoryStages {
            private final AuthenticatorAttestationResponseBuilder builder = new AuthenticatorAttestationResponseBuilder();

            public Step2 attestationObject(ByteArray attestationObject) {
                this.builder.attestationObject(attestationObject);
                return new Step2();
            }

            public class Step2 {
                public AuthenticatorAttestationResponseBuilder clientDataJSON(ByteArray clientDataJSON) {
                    return MandatoryStages.this.builder.clientDataJSON(clientDataJSON);
                }
            }
        }
    }
}

