/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.ByteArray;
import java.util.List;
import lombok.NonNull;

public final class AssertionResult {
    private final boolean success;
    @NonNull
    private final ByteArray credentialId;
    @NonNull
    private final ByteArray userHandle;
    @NonNull
    private final String username;
    private final long signatureCount;
    private final boolean signatureCounterValid;
    @NonNull
    private final List<String> warnings;

    @JsonCreator
    private AssertionResult(@JsonProperty(value="success") boolean success, @JsonProperty(value="credentialId") @NonNull ByteArray credentialId, @JsonProperty(value="userHandle") @NonNull ByteArray userHandle, @JsonProperty(value="username") @NonNull String username, @JsonProperty(value="signatureCount") long signatureCount, @JsonProperty(value="signatureCounterValid") boolean signatureCounterValid, @JsonProperty(value="warnings") @NonNull List<String> warnings) {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (warnings == null) {
            throw new NullPointerException("warnings is marked non-null but is null");
        }
        this.success = success;
        this.credentialId = credentialId;
        this.userHandle = userHandle;
        this.username = username;
        this.signatureCount = signatureCount;
        this.signatureCounterValid = signatureCounterValid;
        this.warnings = CollectionUtil.immutableList(warnings);
    }

    static AssertionResultBuilder.MandatoryStages builder() {
        return new AssertionResultBuilder.MandatoryStages();
    }

    public AssertionResultBuilder toBuilder() {
        return new AssertionResultBuilder().success(this.success).credentialId(this.credentialId).userHandle(this.userHandle).username(this.username).signatureCount(this.signatureCount).signatureCounterValid(this.signatureCounterValid).warnings(this.warnings);
    }

    public boolean isSuccess() {
        return this.success;
    }

    @NonNull
    public ByteArray getCredentialId() {
        return this.credentialId;
    }

    @NonNull
    public ByteArray getUserHandle() {
        return this.userHandle;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    public long getSignatureCount() {
        return this.signatureCount;
    }

    public boolean isSignatureCounterValid() {
        return this.signatureCounterValid;
    }

    @NonNull
    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionResult)) {
            return false;
        }
        AssertionResult other = (AssertionResult)o;
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        ByteArray this$credentialId = this.getCredentialId();
        ByteArray other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId)) {
            return false;
        }
        ByteArray this$userHandle = this.getUserHandle();
        ByteArray other$userHandle = other.getUserHandle();
        if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        if (this.isSignatureCounterValid() != other.isSignatureCounterValid()) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        ByteArray $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        ByteArray $userHandle = this.getUserHandle();
        result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        result = result * 59 + (this.isSignatureCounterValid() ? 79 : 97);
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        return result;
    }

    public String toString() {
        return "AssertionResult(success=" + this.isSuccess() + ", credentialId=" + this.getCredentialId() + ", userHandle=" + this.getUserHandle() + ", username=" + this.getUsername() + ", signatureCount=" + this.getSignatureCount() + ", signatureCounterValid=" + this.isSignatureCounterValid() + ", warnings=" + this.getWarnings() + ")";
    }

    static class AssertionResultBuilder {
        private boolean success;
        private ByteArray credentialId;
        private ByteArray userHandle;
        private String username;
        private long signatureCount;
        private boolean signatureCounterValid;
        private List<String> warnings;

        AssertionResultBuilder() {
        }

        public AssertionResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public AssertionResultBuilder credentialId(@NonNull ByteArray credentialId) {
            if (credentialId == null) {
                throw new NullPointerException("credentialId is marked non-null but is null");
            }
            this.credentialId = credentialId;
            return this;
        }

        public AssertionResultBuilder userHandle(@NonNull ByteArray userHandle) {
            if (userHandle == null) {
                throw new NullPointerException("userHandle is marked non-null but is null");
            }
            this.userHandle = userHandle;
            return this;
        }

        public AssertionResultBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        public AssertionResultBuilder signatureCount(long signatureCount) {
            this.signatureCount = signatureCount;
            return this;
        }

        public AssertionResultBuilder signatureCounterValid(boolean signatureCounterValid) {
            this.signatureCounterValid = signatureCounterValid;
            return this;
        }

        public AssertionResultBuilder warnings(@NonNull List<String> warnings) {
            if (warnings == null) {
                throw new NullPointerException("warnings is marked non-null but is null");
            }
            this.warnings = warnings;
            return this;
        }

        public AssertionResult build() {
            return new AssertionResult(this.success, this.credentialId, this.userHandle, this.username, this.signatureCount, this.signatureCounterValid, this.warnings);
        }

        public String toString() {
            return "AssertionResult.AssertionResultBuilder(success=" + this.success + ", credentialId=" + this.credentialId + ", userHandle=" + this.userHandle + ", username=" + this.username + ", signatureCount=" + this.signatureCount + ", signatureCounterValid=" + this.signatureCounterValid + ", warnings=" + this.warnings + ")";
        }

        public static class MandatoryStages {
            private final AssertionResultBuilder builder = new AssertionResultBuilder();

            public Step2 success(boolean success) {
                this.builder.success(success);
                return new Step2();
            }

            public class Step7 {
                public AssertionResultBuilder warnings(List<String> warnings) {
                    return MandatoryStages.this.builder.warnings(warnings);
                }
            }

            public class Step6 {
                public Step7 signatureCounterValid(boolean signatureCounterValid) {
                    MandatoryStages.this.builder.signatureCounterValid(signatureCounterValid);
                    return new Step7();
                }
            }

            public class Step5 {
                public Step6 signatureCount(long signatureCount) {
                    MandatoryStages.this.builder.signatureCount(signatureCount);
                    return new Step6();
                }
            }

            public class Step4 {
                public Step5 username(String username) {
                    MandatoryStages.this.builder.username(username);
                    return new Step5();
                }
            }

            public class Step3 {
                public Step4 userHandle(ByteArray userHandle) {
                    MandatoryStages.this.builder.userHandle(userHandle);
                    return new Step4();
                }
            }

            public class Step2 {
                public Step3 credentialId(ByteArray credentialId) {
                    MandatoryStages.this.builder.credentialId(credentialId);
                    return new Step3();
                }
            }
        }
    }
}

