/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.util.Optional;
import lombok.NonNull;

public final class AuthenticatorSelectionCriteria {
    private final AuthenticatorAttachment authenticatorAttachment;
    private final boolean requireResidentKey;
    @NonNull
    private final UserVerificationRequirement userVerification;

    public Optional<AuthenticatorAttachment> getAuthenticatorAttachment() {
        return Optional.ofNullable(this.authenticatorAttachment);
    }

    @JsonCreator
    private AuthenticatorSelectionCriteria(@JsonProperty(value="authenticatorAttachment") AuthenticatorAttachment authenticatorAttachment, @JsonProperty(value="requireResidentKey") boolean requireResidentKey, @JsonProperty(value="userVerification") @NonNull UserVerificationRequirement userVerification) {
        if (userVerification == null) {
            throw new NullPointerException("userVerification is marked non-null but is null");
        }
        this.authenticatorAttachment = authenticatorAttachment;
        this.requireResidentKey = requireResidentKey;
        this.userVerification = userVerification;
    }

    private static boolean $default$requireResidentKey() {
        return false;
    }

    private static UserVerificationRequirement $default$userVerification() {
        return UserVerificationRequirement.PREFERRED;
    }

    public static AuthenticatorSelectionCriteriaBuilder builder() {
        return new AuthenticatorSelectionCriteriaBuilder();
    }

    public AuthenticatorSelectionCriteriaBuilder toBuilder() {
        return new AuthenticatorSelectionCriteriaBuilder().authenticatorAttachment(this.authenticatorAttachment).requireResidentKey(this.requireResidentKey).userVerification(this.userVerification);
    }

    public boolean isRequireResidentKey() {
        return this.requireResidentKey;
    }

    @NonNull
    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorSelectionCriteria)) {
            return false;
        }
        AuthenticatorSelectionCriteria other = (AuthenticatorSelectionCriteria)o;
        Optional<AuthenticatorAttachment> this$authenticatorAttachment = this.getAuthenticatorAttachment();
        Optional<AuthenticatorAttachment> other$authenticatorAttachment = other.getAuthenticatorAttachment();
        if (this$authenticatorAttachment == null ? other$authenticatorAttachment != null : !((Object)this$authenticatorAttachment).equals(other$authenticatorAttachment)) {
            return false;
        }
        if (this.isRequireResidentKey() != other.isRequireResidentKey()) {
            return false;
        }
        UserVerificationRequirement this$userVerification = this.getUserVerification();
        UserVerificationRequirement other$userVerification = other.getUserVerification();
        return !(this$userVerification == null ? other$userVerification != null : !((Object)((Object)this$userVerification)).equals((Object)other$userVerification));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<AuthenticatorAttachment> $authenticatorAttachment = this.getAuthenticatorAttachment();
        result = result * 59 + ($authenticatorAttachment == null ? 43 : ((Object)$authenticatorAttachment).hashCode());
        result = result * 59 + (this.isRequireResidentKey() ? 79 : 97);
        UserVerificationRequirement $userVerification = this.getUserVerification();
        result = result * 59 + ($userVerification == null ? 43 : ((Object)((Object)$userVerification)).hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticatorSelectionCriteria(authenticatorAttachment=" + this.getAuthenticatorAttachment() + ", requireResidentKey=" + this.isRequireResidentKey() + ", userVerification=" + (Object)((Object)this.getUserVerification()) + ")";
    }

    public static class AuthenticatorSelectionCriteriaBuilder {
        private boolean requireResidentKey$set;
        private boolean requireResidentKey;
        private boolean userVerification$set;
        private UserVerificationRequirement userVerification;
        private AuthenticatorAttachment authenticatorAttachment = null;

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(@NonNull Optional<AuthenticatorAttachment> authenticatorAttachment) {
            if (authenticatorAttachment == null) {
                throw new NullPointerException("authenticatorAttachment is marked non-null but is null");
            }
            return this.authenticatorAttachment((AuthenticatorAttachment)authenticatorAttachment.orElse(null));
        }

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        AuthenticatorSelectionCriteriaBuilder() {
        }

        public AuthenticatorSelectionCriteriaBuilder requireResidentKey(boolean requireResidentKey) {
            this.requireResidentKey = requireResidentKey;
            this.requireResidentKey$set = true;
            return this;
        }

        public AuthenticatorSelectionCriteriaBuilder userVerification(@NonNull UserVerificationRequirement userVerification) {
            if (userVerification == null) {
                throw new NullPointerException("userVerification is marked non-null but is null");
            }
            this.userVerification = userVerification;
            this.userVerification$set = true;
            return this;
        }

        public AuthenticatorSelectionCriteria build() {
            boolean requireResidentKey = this.requireResidentKey;
            if (!this.requireResidentKey$set) {
                requireResidentKey = AuthenticatorSelectionCriteria.$default$requireResidentKey();
            }
            UserVerificationRequirement userVerification = this.userVerification;
            if (!this.userVerification$set) {
                userVerification = AuthenticatorSelectionCriteria.$default$userVerification();
            }
            return new AuthenticatorSelectionCriteria(this.authenticatorAttachment, requireResidentKey, userVerification);
        }

        public String toString() {
            return "AuthenticatorSelectionCriteria.AuthenticatorSelectionCriteriaBuilder(authenticatorAttachment=" + (Object)((Object)this.authenticatorAttachment) + ", requireResidentKey=" + this.requireResidentKey + ", userVerification=" + (Object)((Object)this.userVerification) + ")";
        }
    }
}

