/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.meta;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.internal.util.json.JsonStringSerializable;
import com.yubico.internal.util.json.JsonStringSerializer;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

@JsonSerialize(using=JsonStringSerializer.class)
public enum DocumentStatus implements JsonStringSerializable
{
    EDITORS_DRAFT("editors-draft"),
    WORKING_DRAFT("working-draft"),
    CANDIDATE_RECOMMENDATION("candidate-recommendation"),
    PROPOSED_RECOMMENDATION("proposed-recommendation"),
    RECOMMENDATION("recommendation");

    private final String id;

    static Optional<DocumentStatus> fromString(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Stream.of(DocumentStatus.values()).filter(v -> v.id.equals(id)).findAny();
    }

    public String toJsonString() {
        return this.id;
    }

    private DocumentStatus(String id) {
        this.id = id;
    }
}

