/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.data.AssertionExtensionInputs;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class StartAssertionOptions {
    private final String username;
    @NonNull
    private final AssertionExtensionInputs extensions;
    private final UserVerificationRequirement userVerification;
    private final Long timeout;

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<UserVerificationRequirement> getUserVerification() {
        return Optional.ofNullable(this.userVerification);
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Generated
    private static AssertionExtensionInputs $default$extensions() {
        return AssertionExtensionInputs.builder().build();
    }

    @Generated
    StartAssertionOptions(String username, @NonNull AssertionExtensionInputs extensions, UserVerificationRequirement userVerification, Long timeout) {
        if (extensions == null) {
            throw new NullPointerException("extensions is marked non-null but is null");
        }
        this.username = username;
        this.extensions = extensions;
        this.userVerification = userVerification;
        this.timeout = timeout;
    }

    @Generated
    public static StartAssertionOptionsBuilder builder() {
        return new StartAssertionOptionsBuilder();
    }

    @Generated
    public StartAssertionOptionsBuilder toBuilder() {
        return new StartAssertionOptionsBuilder().username(this.username).extensions(this.extensions).userVerification(this.userVerification).timeout(this.timeout);
    }

    @NonNull
    @Generated
    public AssertionExtensionInputs getExtensions() {
        return this.extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartAssertionOptions)) {
            return false;
        }
        StartAssertionOptions other = (StartAssertionOptions)o;
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        AssertionExtensionInputs this$extensions = this.getExtensions();
        AssertionExtensionInputs other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        Optional<UserVerificationRequirement> this$userVerification = this.getUserVerification();
        Optional<UserVerificationRequirement> other$userVerification = other.getUserVerification();
        if (this$userVerification == null ? other$userVerification != null : !((Object)this$userVerification).equals(other$userVerification)) {
            return false;
        }
        Optional<Long> this$timeout = this.getTimeout();
        Optional<Long> other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        AssertionExtensionInputs $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        Optional<UserVerificationRequirement> $userVerification = this.getUserVerification();
        result = result * 59 + ($userVerification == null ? 43 : ((Object)$userVerification).hashCode());
        Optional<Long> $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StartAssertionOptions(username=" + this.getUsername() + ", extensions=" + this.getExtensions() + ", userVerification=" + this.getUserVerification() + ", timeout=" + this.getTimeout() + ")";
    }

    public static class StartAssertionOptionsBuilder {
        @Generated
        private boolean extensions$set;
        @Generated
        private AssertionExtensionInputs extensions;
        private String username = null;
        private UserVerificationRequirement userVerification = null;
        private Long timeout = null;

        public StartAssertionOptionsBuilder username(@NonNull Optional<String> username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username.orElse(null);
            return this;
        }

        public StartAssertionOptionsBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            return this.username(Optional.of(username));
        }

        public StartAssertionOptionsBuilder userVerification(@NonNull Optional<UserVerificationRequirement> userVerification) {
            if (userVerification == null) {
                throw new NullPointerException("userVerification is marked non-null but is null");
            }
            this.userVerification = userVerification.orElse(null);
            return this;
        }

        public StartAssertionOptionsBuilder userVerification(@NonNull UserVerificationRequirement userVerification) {
            if (userVerification == null) {
                throw new NullPointerException("userVerification is marked non-null but is null");
            }
            return this.userVerification(Optional.of(userVerification));
        }

        public StartAssertionOptionsBuilder timeout(@NonNull Optional<Long> timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            if (timeout.isPresent() && timeout.get() <= 0L) {
                throw new IllegalArgumentException("timeout must be positive, was: " + timeout.get());
            }
            this.timeout = timeout.orElse(null);
            return this;
        }

        public StartAssertionOptionsBuilder timeout(long timeout) {
            return this.timeout(Optional.of(timeout));
        }

        @Generated
        StartAssertionOptionsBuilder() {
        }

        @Generated
        public StartAssertionOptionsBuilder extensions(@NonNull AssertionExtensionInputs extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions is marked non-null but is null");
            }
            this.extensions = extensions;
            this.extensions$set = true;
            return this;
        }

        @Generated
        public StartAssertionOptions build() {
            AssertionExtensionInputs extensions = this.extensions;
            if (!this.extensions$set) {
                extensions = StartAssertionOptions.$default$extensions();
            }
            return new StartAssertionOptions(this.username, extensions, this.userVerification, this.timeout);
        }

        @Generated
        public String toString() {
            return "StartAssertionOptions.StartAssertionOptionsBuilder(username=" + this.username + ", extensions=" + this.extensions + ", userVerification=" + (Object)((Object)this.userVerification) + ", timeout=" + this.timeout + ")";
        }
    }
}

