/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.internal.util.json.JsonStringSerializable;
import com.yubico.internal.util.json.JsonStringSerializer;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

@JsonSerialize(using=JsonStringSerializer.class)
public final class AuthenticatorTransport
implements Comparable<AuthenticatorTransport>,
JsonStringSerializable {
    @NonNull
    private final String id;
    public static final AuthenticatorTransport USB = new AuthenticatorTransport("usb");
    public static final AuthenticatorTransport NFC = new AuthenticatorTransport("nfc");
    public static final AuthenticatorTransport BLE = new AuthenticatorTransport("ble");
    public static final AuthenticatorTransport INTERNAL = new AuthenticatorTransport("internal");

    public static AuthenticatorTransport[] values() {
        return new AuthenticatorTransport[]{USB, NFC, BLE, INTERNAL};
    }

    public static AuthenticatorTransport of(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Stream.of(AuthenticatorTransport.values()).filter(v -> v.getId().equals(id)).findAny().orElseGet(() -> new AuthenticatorTransport(id));
    }

    public static AuthenticatorTransport valueOf(String name) {
        switch (name) {
            case "USB": {
                return USB;
            }
            case "NFC": {
                return NFC;
            }
            case "BLE": {
                return BLE;
            }
            case "INTERNAL": {
                return INTERNAL;
            }
        }
        throw new IllegalArgumentException("No enum constant com.yubico.webauthn.data.AuthenticatorTransport." + name);
    }

    public String toJsonString() {
        return this.id;
    }

    @Override
    public int compareTo(AuthenticatorTransport other) {
        return this.id.compareTo(other.id);
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorTransport)) {
            return false;
        }
        AuthenticatorTransport other = (AuthenticatorTransport)o;
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorTransport(id=" + this.getId() + ")";
    }

    @Generated
    private AuthenticatorTransport(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }
}

