/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class AuthenticatorSelectionCriteria {
    private final AuthenticatorAttachment authenticatorAttachment;
    private final boolean requireResidentKey;
    @NonNull
    private final UserVerificationRequirement userVerification;

    public Optional<AuthenticatorAttachment> getAuthenticatorAttachment() {
        return Optional.ofNullable(this.authenticatorAttachment);
    }

    @JsonCreator
    private AuthenticatorSelectionCriteria(@JsonProperty(value="authenticatorAttachment") AuthenticatorAttachment authenticatorAttachment, @JsonProperty(value="requireResidentKey") boolean requireResidentKey, @JsonProperty(value="userVerification") @NonNull UserVerificationRequirement userVerification) {
        if (userVerification == null) {
            throw new NullPointerException("userVerification is marked non-null but is null");
        }
        this.authenticatorAttachment = authenticatorAttachment;
        this.requireResidentKey = requireResidentKey;
        this.userVerification = userVerification;
    }

    @Generated
    private static boolean $default$requireResidentKey() {
        return false;
    }

    @Generated
    private static UserVerificationRequirement $default$userVerification() {
        return UserVerificationRequirement.PREFERRED;
    }

    @Generated
    public static AuthenticatorSelectionCriteriaBuilder builder() {
        return new AuthenticatorSelectionCriteriaBuilder();
    }

    @Generated
    public AuthenticatorSelectionCriteriaBuilder toBuilder() {
        return new AuthenticatorSelectionCriteriaBuilder().authenticatorAttachment(this.authenticatorAttachment).requireResidentKey(this.requireResidentKey).userVerification(this.userVerification);
    }

    @Generated
    public boolean isRequireResidentKey() {
        return this.requireResidentKey;
    }

    @NonNull
    @Generated
    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorSelectionCriteria)) {
            return false;
        }
        AuthenticatorSelectionCriteria other = (AuthenticatorSelectionCriteria)o;
        Optional<AuthenticatorAttachment> this$authenticatorAttachment = this.getAuthenticatorAttachment();
        Optional<AuthenticatorAttachment> other$authenticatorAttachment = other.getAuthenticatorAttachment();
        if (this$authenticatorAttachment == null ? other$authenticatorAttachment != null : !((Object)this$authenticatorAttachment).equals(other$authenticatorAttachment)) {
            return false;
        }
        if (this.isRequireResidentKey() != other.isRequireResidentKey()) {
            return false;
        }
        UserVerificationRequirement this$userVerification = this.getUserVerification();
        UserVerificationRequirement other$userVerification = other.getUserVerification();
        return !(this$userVerification == null ? other$userVerification != null : !((Object)((Object)this$userVerification)).equals((Object)other$userVerification));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<AuthenticatorAttachment> $authenticatorAttachment = this.getAuthenticatorAttachment();
        result = result * 59 + ($authenticatorAttachment == null ? 43 : ((Object)$authenticatorAttachment).hashCode());
        result = result * 59 + (this.isRequireResidentKey() ? 79 : 97);
        UserVerificationRequirement $userVerification = this.getUserVerification();
        result = result * 59 + ($userVerification == null ? 43 : ((Object)((Object)$userVerification)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorSelectionCriteria(authenticatorAttachment=" + this.getAuthenticatorAttachment() + ", requireResidentKey=" + this.isRequireResidentKey() + ", userVerification=" + (Object)((Object)this.getUserVerification()) + ")";
    }

    public static class AuthenticatorSelectionCriteriaBuilder {
        @Generated
        private boolean requireResidentKey$set;
        @Generated
        private boolean requireResidentKey$value;
        @Generated
        private boolean userVerification$set;
        @Generated
        private UserVerificationRequirement userVerification$value;
        private AuthenticatorAttachment authenticatorAttachment = null;

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(@NonNull Optional<AuthenticatorAttachment> authenticatorAttachment) {
            if (authenticatorAttachment == null) {
                throw new NullPointerException("authenticatorAttachment is marked non-null but is null");
            }
            return this.authenticatorAttachment((AuthenticatorAttachment)authenticatorAttachment.orElse(null));
        }

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        @Generated
        AuthenticatorSelectionCriteriaBuilder() {
        }

        @Generated
        public AuthenticatorSelectionCriteriaBuilder requireResidentKey(boolean requireResidentKey) {
            this.requireResidentKey$value = requireResidentKey;
            this.requireResidentKey$set = true;
            return this;
        }

        @Generated
        public AuthenticatorSelectionCriteriaBuilder userVerification(@NonNull UserVerificationRequirement userVerification) {
            if (userVerification == null) {
                throw new NullPointerException("userVerification is marked non-null but is null");
            }
            this.userVerification$value = userVerification;
            this.userVerification$set = true;
            return this;
        }

        @Generated
        public AuthenticatorSelectionCriteria build() {
            boolean requireResidentKey$value = this.requireResidentKey$value;
            if (!this.requireResidentKey$set) {
                requireResidentKey$value = AuthenticatorSelectionCriteria.$default$requireResidentKey();
            }
            UserVerificationRequirement userVerification$value = this.userVerification$value;
            if (!this.userVerification$set) {
                userVerification$value = AuthenticatorSelectionCriteria.$default$userVerification();
            }
            return new AuthenticatorSelectionCriteria(this.authenticatorAttachment, requireResidentKey$value, userVerification$value);
        }

        @Generated
        public String toString() {
            return "AuthenticatorSelectionCriteria.AuthenticatorSelectionCriteriaBuilder(authenticatorAttachment=" + (Object)((Object)this.authenticatorAttachment) + ", requireResidentKey$value=" + this.requireResidentKey$value + ", userVerification$value=" + (Object)((Object)this.userVerification$value) + ")";
        }
    }
}

