/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.data.AuthenticatorData;
import com.yubico.webauthn.data.ByteArray;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;

@JsonSerialize(using=JsonSerializer.class)
public final class AttestationObject {
    @NonNull
    private final ByteArray bytes;
    @NonNull
    private final transient AuthenticatorData authenticatorData;
    @NonNull
    private final transient String format;
    @NonNull
    private final transient ObjectNode attestationStatement;

    @JsonCreator
    public AttestationObject(@NonNull ByteArray bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        this.bytes = bytes;
        JsonNode decoded = JacksonCodecs.cbor().readTree(bytes.getBytes());
        ExceptionUtil.assure((decoded != null ? 1 : 0) != 0, (String)"Failed to parse attestation object from bytes: %s", (Object[])new Object[]{bytes.getBase64Url()});
        if (!decoded.isObject()) {
            throw new IllegalArgumentException("Attestation object must be a JSON object.");
        }
        JsonNode authData = decoded.get("authData");
        if (authData == null) {
            throw new IllegalArgumentException("Required property \"authData\" missing from attestation object: " + bytes.getBase64Url());
        }
        if (!authData.isBinary()) {
            throw new IllegalArgumentException(String.format("Property \"authData\" of attestation object must be a CBOR byte array, was: %s. Attestation object: %s", authData.getNodeType(), bytes.getBase64Url()));
        }
        ByteArray authDataBytes = new ByteArray(authData.binaryValue());
        JsonNode format = decoded.get("fmt");
        if (format == null) {
            throw new IllegalArgumentException("Required property \"fmt\" missing from attestation object: " + bytes.getBase64Url());
        }
        if (!format.isTextual()) {
            throw new IllegalArgumentException(String.format("Property \"fmt\" of attestation object must be a CBOR text value, was: %s. Attestation object: %s", format.getNodeType(), bytes.getBase64Url()));
        }
        this.format = decoded.get("fmt").textValue();
        JsonNode attStmt = decoded.get("attStmt");
        if (attStmt == null) {
            throw new IllegalArgumentException("Required property \"attStmt\" missing from attestation object: " + bytes.getBase64Url());
        }
        if (!attStmt.isObject()) {
            throw new IllegalArgumentException(String.format("Property \"attStmt\" of attestation object must be a CBOR map, was: %s. Attestation object: %s", attStmt.getNodeType(), bytes.getBase64Url()));
        }
        this.attestationStatement = (ObjectNode)attStmt;
        this.authenticatorData = new AuthenticatorData(authDataBytes);
    }

    @NonNull
    @Generated
    public ByteArray getBytes() {
        return this.bytes;
    }

    @NonNull
    @Generated
    public AuthenticatorData getAuthenticatorData() {
        return this.authenticatorData;
    }

    @NonNull
    @Generated
    public String getFormat() {
        return this.format;
    }

    @NonNull
    @Generated
    public ObjectNode getAttestationStatement() {
        return this.attestationStatement;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttestationObject)) {
            return false;
        }
        AttestationObject other = (AttestationObject)o;
        ByteArray this$bytes = this.getBytes();
        ByteArray other$bytes = other.getBytes();
        return !(this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AttestationObject(bytes=" + this.getBytes() + ", authenticatorData=" + this.getAuthenticatorData() + ", format=" + this.getFormat() + ", attestationStatement=" + this.getAttestationStatement() + ")";
    }

    static class JsonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<AttestationObject> {
        JsonSerializer() {
        }

        public void serialize(AttestationObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getBytes().getBase64Url());
        }
    }
}

