/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.ByteArray;
import java.security.cert.CertStore;
import java.security.cert.PolicyNode;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;

public interface AttestationTrustSource {
    public TrustRootsResult findTrustRoots(List<X509Certificate> var1, Optional<ByteArray> var2);

    public static final class TrustRootsResult {
        @NonNull
        private final Set<X509Certificate> trustRoots;
        private final CertStore certStore;
        private final boolean enableRevocationChecking;
        private final Predicate<PolicyNode> policyTreeValidator;

        private TrustRootsResult(@NonNull Set<X509Certificate> trustRoots, CertStore certStore, boolean enableRevocationChecking, Predicate<PolicyNode> policyTreeValidator) {
            if (trustRoots == null) {
                throw new NullPointerException("trustRoots is marked non-null but is null");
            }
            this.trustRoots = CollectionUtil.immutableSet(trustRoots);
            this.certStore = certStore;
            this.enableRevocationChecking = enableRevocationChecking;
            this.policyTreeValidator = policyTreeValidator;
        }

        public Optional<CertStore> getCertStore() {
            return Optional.ofNullable(this.certStore);
        }

        public Optional<Predicate<PolicyNode>> getPolicyTreeValidator() {
            return Optional.ofNullable(this.policyTreeValidator);
        }

        public static TrustRootsResultBuilder.Step1 builder() {
            return new TrustRootsResultBuilder.Step1();
        }

        @Generated
        private static CertStore $default$certStore() {
            return null;
        }

        @Generated
        private static boolean $default$enableRevocationChecking() {
            return true;
        }

        @Generated
        private static Predicate<PolicyNode> $default$policyTreeValidator() {
            return null;
        }

        @Generated
        public TrustRootsResultBuilder toBuilder() {
            return new TrustRootsResultBuilder().trustRoots(this.trustRoots).certStore(this.certStore).enableRevocationChecking(this.enableRevocationChecking).policyTreeValidator(this.policyTreeValidator);
        }

        @NonNull
        @Generated
        public Set<X509Certificate> getTrustRoots() {
            return this.trustRoots;
        }

        @Generated
        public boolean isEnableRevocationChecking() {
            return this.enableRevocationChecking;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrustRootsResult)) {
                return false;
            }
            TrustRootsResult other = (TrustRootsResult)o;
            if (this.isEnableRevocationChecking() != other.isEnableRevocationChecking()) {
                return false;
            }
            Set<X509Certificate> this$trustRoots = this.getTrustRoots();
            Set<X509Certificate> other$trustRoots = other.getTrustRoots();
            if (this$trustRoots == null ? other$trustRoots != null : !((Object)this$trustRoots).equals(other$trustRoots)) {
                return false;
            }
            Optional<CertStore> this$certStore = this.getCertStore();
            Optional<CertStore> other$certStore = other.getCertStore();
            if (this$certStore == null ? other$certStore != null : !((Object)this$certStore).equals(other$certStore)) {
                return false;
            }
            Optional<Predicate<PolicyNode>> this$policyTreeValidator = this.getPolicyTreeValidator();
            Optional<Predicate<PolicyNode>> other$policyTreeValidator = other.getPolicyTreeValidator();
            return !(this$policyTreeValidator == null ? other$policyTreeValidator != null : !((Object)this$policyTreeValidator).equals(other$policyTreeValidator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableRevocationChecking() ? 79 : 97);
            Set<X509Certificate> $trustRoots = this.getTrustRoots();
            result = result * 59 + ($trustRoots == null ? 43 : ((Object)$trustRoots).hashCode());
            Optional<CertStore> $certStore = this.getCertStore();
            result = result * 59 + ($certStore == null ? 43 : ((Object)$certStore).hashCode());
            Optional<Predicate<PolicyNode>> $policyTreeValidator = this.getPolicyTreeValidator();
            result = result * 59 + ($policyTreeValidator == null ? 43 : ((Object)$policyTreeValidator).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AttestationTrustSource.TrustRootsResult(trustRoots=" + this.getTrustRoots() + ", certStore=" + this.getCertStore() + ", enableRevocationChecking=" + this.isEnableRevocationChecking() + ", policyTreeValidator=" + this.getPolicyTreeValidator() + ")";
        }

        public static class TrustRootsResultBuilder {
            @Generated
            private Set<X509Certificate> trustRoots;
            @Generated
            private boolean certStore$set;
            @Generated
            private CertStore certStore$value;
            @Generated
            private boolean enableRevocationChecking$set;
            @Generated
            private boolean enableRevocationChecking$value;
            @Generated
            private boolean policyTreeValidator$set;
            @Generated
            private Predicate<PolicyNode> policyTreeValidator$value;

            @Generated
            TrustRootsResultBuilder() {
            }

            @Generated
            public TrustRootsResultBuilder trustRoots(@NonNull Set<X509Certificate> trustRoots) {
                if (trustRoots == null) {
                    throw new NullPointerException("trustRoots is marked non-null but is null");
                }
                this.trustRoots = trustRoots;
                return this;
            }

            @Generated
            public TrustRootsResultBuilder certStore(CertStore certStore) {
                this.certStore$value = certStore;
                this.certStore$set = true;
                return this;
            }

            @Generated
            public TrustRootsResultBuilder enableRevocationChecking(boolean enableRevocationChecking) {
                this.enableRevocationChecking$value = enableRevocationChecking;
                this.enableRevocationChecking$set = true;
                return this;
            }

            @Generated
            public TrustRootsResultBuilder policyTreeValidator(Predicate<PolicyNode> policyTreeValidator) {
                this.policyTreeValidator$value = policyTreeValidator;
                this.policyTreeValidator$set = true;
                return this;
            }

            @Generated
            public TrustRootsResult build() {
                CertStore certStore$value = this.certStore$value;
                if (!this.certStore$set) {
                    certStore$value = TrustRootsResult.$default$certStore();
                }
                boolean enableRevocationChecking$value = this.enableRevocationChecking$value;
                if (!this.enableRevocationChecking$set) {
                    enableRevocationChecking$value = TrustRootsResult.$default$enableRevocationChecking();
                }
                Predicate policyTreeValidator$value = this.policyTreeValidator$value;
                if (!this.policyTreeValidator$set) {
                    policyTreeValidator$value = TrustRootsResult.$default$policyTreeValidator();
                }
                return new TrustRootsResult(this.trustRoots, certStore$value, enableRevocationChecking$value, policyTreeValidator$value);
            }

            @Generated
            public String toString() {
                return "AttestationTrustSource.TrustRootsResult.TrustRootsResultBuilder(trustRoots=" + this.trustRoots + ", certStore$value=" + this.certStore$value + ", enableRevocationChecking$value=" + this.enableRevocationChecking$value + ", policyTreeValidator$value=" + this.policyTreeValidator$value + ")";
            }

            public static class Step1 {
                public TrustRootsResultBuilder trustRoots(@NonNull Set<X509Certificate> trustRoots) {
                    if (trustRoots == null) {
                        throw new NullPointerException("trustRoots is marked non-null but is null");
                    }
                    return new TrustRootsResultBuilder().trustRoots(trustRoots);
                }
            }
        }
    }
}

