/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.data.ByteArray;
import lombok.Generated;
import lombok.NonNull;

public final class RegisteredCredential {
    @NonNull
    private final ByteArray credentialId;
    @NonNull
    private final ByteArray userHandle;
    @NonNull
    private final ByteArray publicKeyCose;
    private final long signatureCount;

    @JsonCreator
    private RegisteredCredential(@JsonProperty(value="credentialId") @NonNull ByteArray credentialId, @JsonProperty(value="userHandle") @NonNull ByteArray userHandle, @JsonProperty(value="publicKeyCose") @NonNull ByteArray publicKeyCose, @JsonProperty(value="signatureCount") long signatureCount) {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        this.credentialId = credentialId;
        this.userHandle = userHandle;
        this.publicKeyCose = publicKeyCose;
        this.signatureCount = signatureCount;
    }

    public static RegisteredCredentialBuilder.MandatoryStages builder() {
        return new RegisteredCredentialBuilder.MandatoryStages();
    }

    @Generated
    private static long $default$signatureCount() {
        return 0L;
    }

    @Generated
    public RegisteredCredentialBuilder toBuilder() {
        return new RegisteredCredentialBuilder().credentialId(this.credentialId).userHandle(this.userHandle).publicKeyCose(this.publicKeyCose).signatureCount(this.signatureCount);
    }

    @NonNull
    @Generated
    public ByteArray getCredentialId() {
        return this.credentialId;
    }

    @NonNull
    @Generated
    public ByteArray getUserHandle() {
        return this.userHandle;
    }

    @NonNull
    @Generated
    public ByteArray getPublicKeyCose() {
        return this.publicKeyCose;
    }

    @Generated
    public long getSignatureCount() {
        return this.signatureCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredCredential)) {
            return false;
        }
        RegisteredCredential other = (RegisteredCredential)o;
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        ByteArray this$credentialId = this.getCredentialId();
        ByteArray other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId)) {
            return false;
        }
        ByteArray this$userHandle = this.getUserHandle();
        ByteArray other$userHandle = other.getUserHandle();
        if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
            return false;
        }
        ByteArray this$publicKeyCose = this.getPublicKeyCose();
        ByteArray other$publicKeyCose = other.getPublicKeyCose();
        return !(this$publicKeyCose == null ? other$publicKeyCose != null : !((Object)this$publicKeyCose).equals(other$publicKeyCose));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        ByteArray $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        ByteArray $userHandle = this.getUserHandle();
        result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
        ByteArray $publicKeyCose = this.getPublicKeyCose();
        result = result * 59 + ($publicKeyCose == null ? 43 : ((Object)$publicKeyCose).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegisteredCredential(credentialId=" + this.getCredentialId() + ", userHandle=" + this.getUserHandle() + ", publicKeyCose=" + this.getPublicKeyCose() + ", signatureCount=" + this.getSignatureCount() + ")";
    }

    public static class RegisteredCredentialBuilder {
        @Generated
        private ByteArray credentialId;
        @Generated
        private ByteArray userHandle;
        @Generated
        private ByteArray publicKeyCose;
        @Generated
        private boolean signatureCount$set;
        @Generated
        private long signatureCount$value;

        public RegisteredCredentialBuilder publicKeyCose(@NonNull ByteArray publicKeyCose) {
            if (publicKeyCose == null) {
                throw new NullPointerException("publicKeyCose is marked non-null but is null");
            }
            this.publicKeyCose = publicKeyCose;
            return this;
        }

        public RegisteredCredentialBuilder publicKeyEs256Raw(ByteArray publicKeyEs256Raw) {
            return this.publicKeyCose(WebAuthnCodecs.rawEcKeyToCose(publicKeyEs256Raw));
        }

        @Generated
        RegisteredCredentialBuilder() {
        }

        @Generated
        public RegisteredCredentialBuilder credentialId(@NonNull ByteArray credentialId) {
            if (credentialId == null) {
                throw new NullPointerException("credentialId is marked non-null but is null");
            }
            this.credentialId = credentialId;
            return this;
        }

        @Generated
        public RegisteredCredentialBuilder userHandle(@NonNull ByteArray userHandle) {
            if (userHandle == null) {
                throw new NullPointerException("userHandle is marked non-null but is null");
            }
            this.userHandle = userHandle;
            return this;
        }

        @Generated
        public RegisteredCredentialBuilder signatureCount(long signatureCount) {
            this.signatureCount$value = signatureCount;
            this.signatureCount$set = true;
            return this;
        }

        @Generated
        public RegisteredCredential build() {
            long signatureCount$value = this.signatureCount$value;
            if (!this.signatureCount$set) {
                signatureCount$value = RegisteredCredential.$default$signatureCount();
            }
            return new RegisteredCredential(this.credentialId, this.userHandle, this.publicKeyCose, signatureCount$value);
        }

        @Generated
        public String toString() {
            return "RegisteredCredential.RegisteredCredentialBuilder(credentialId=" + this.credentialId + ", userHandle=" + this.userHandle + ", publicKeyCose=" + this.publicKeyCose + ", signatureCount$value=" + this.signatureCount$value + ")";
        }

        public static class MandatoryStages {
            private final RegisteredCredentialBuilder builder = new RegisteredCredentialBuilder();

            public Step2 credentialId(ByteArray credentialId) {
                this.builder.credentialId(credentialId);
                return new Step2();
            }

            public class Step2 {
                public Step3 userHandle(ByteArray userHandle) {
                    MandatoryStages.this.builder.userHandle(userHandle);
                    return new Step3();
                }
            }

            public class Step3 {
                public RegisteredCredentialBuilder publicKeyCose(ByteArray publicKeyCose) {
                    return MandatoryStages.this.builder.publicKeyCose(publicKeyCose);
                }

                public RegisteredCredentialBuilder publicKeyEs256Raw(ByteArray publicKeyEs256Raw) {
                    return MandatoryStages.this.builder.publicKeyCose(WebAuthnCodecs.rawEcKeyToCose(publicKeyEs256Raw));
                }
            }
        }
    }
}

