/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.AuthenticatorAssertionExtensionOutputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class AssertionResult {
    private final boolean success;
    private final RegisteredCredential credential;
    @NonNull
    private final String username;
    private final long signatureCount;
    private final boolean signatureCounterValid;
    private final ClientAssertionExtensionOutputs clientExtensionOutputs;
    private final AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs;

    private AssertionResult(boolean success, @JsonProperty(value="credential") @NonNull RegisteredCredential credential, @NonNull String username, long signatureCount, boolean signatureCounterValid, ClientAssertionExtensionOutputs clientExtensionOutputs, AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs) {
        this(success, credential, username, null, null, signatureCount, signatureCounterValid, clientExtensionOutputs, authenticatorExtensionOutputs);
        if (credential == null) {
            throw new NullPointerException("credential is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    @JsonCreator
    private AssertionResult(@JsonProperty(value="success") boolean success, @JsonProperty(value="credential") @NonNull RegisteredCredential credential, @JsonProperty(value="username") @NonNull String username, @JsonProperty(value="credentialId") ByteArray credentialId, @JsonProperty(value="userHandle") ByteArray userHandle, @JsonProperty(value="signatureCount") long signatureCount, @JsonProperty(value="signatureCounterValid") boolean signatureCounterValid, @JsonProperty(value="clientExtensionOutputs") ClientAssertionExtensionOutputs clientExtensionOutputs, @JsonProperty(value="authenticatorExtensionOutputs") AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs) {
        if (credential == null) {
            throw new NullPointerException("credential is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.success = success;
        this.credential = credential;
        this.username = username;
        if (credentialId != null) {
            ExceptionUtil.assure((boolean)credential.getCredentialId().equals(credentialId), (String)"Legacy credentialId is present and does not equal credential.credentialId", (Object[])new Object[0]);
        }
        if (userHandle != null) {
            ExceptionUtil.assure((boolean)credential.getUserHandle().equals(userHandle), (String)"Legacy userHandle is present and does not equal credential.userHandle", (Object[])new Object[0]);
        }
        this.signatureCount = signatureCount;
        this.signatureCounterValid = signatureCounterValid;
        this.clientExtensionOutputs = clientExtensionOutputs == null || clientExtensionOutputs.getExtensionIds().isEmpty() ? null : clientExtensionOutputs;
        this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
    }

    @Deprecated
    public ByteArray getCredentialId() {
        return this.credential.getCredentialId();
    }

    @Deprecated
    public ByteArray getUserHandle() {
        return this.credential.getUserHandle();
    }

    public Optional<ClientAssertionExtensionOutputs> getClientExtensionOutputs() {
        return Optional.ofNullable(this.clientExtensionOutputs);
    }

    public Optional<AuthenticatorAssertionExtensionOutputs> getAuthenticatorExtensionOutputs() {
        return Optional.ofNullable(this.authenticatorExtensionOutputs);
    }

    static AssertionResultBuilder.MandatoryStages builder() {
        return new AssertionResultBuilder.MandatoryStages();
    }

    @Generated
    public AssertionResultBuilder toBuilder() {
        return new AssertionResultBuilder().success(this.success).credential(this.credential).username(this.username).signatureCount(this.signatureCount).signatureCounterValid(this.signatureCounterValid).clientExtensionOutputs(this.clientExtensionOutputs).authenticatorExtensionOutputs(this.authenticatorExtensionOutputs);
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public RegisteredCredential getCredential() {
        return this.credential;
    }

    @NonNull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public long getSignatureCount() {
        return this.signatureCount;
    }

    @Generated
    public boolean isSignatureCounterValid() {
        return this.signatureCounterValid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionResult)) {
            return false;
        }
        AssertionResult other = (AssertionResult)o;
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        if (this.isSignatureCounterValid() != other.isSignatureCounterValid()) {
            return false;
        }
        RegisteredCredential this$credential = this.getCredential();
        RegisteredCredential other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Optional<ClientAssertionExtensionOutputs> this$clientExtensionOutputs = this.getClientExtensionOutputs();
        Optional<ClientAssertionExtensionOutputs> other$clientExtensionOutputs = other.getClientExtensionOutputs();
        if (this$clientExtensionOutputs == null ? other$clientExtensionOutputs != null : !((Object)this$clientExtensionOutputs).equals(other$clientExtensionOutputs)) {
            return false;
        }
        Optional<AuthenticatorAssertionExtensionOutputs> this$authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        Optional<AuthenticatorAssertionExtensionOutputs> other$authenticatorExtensionOutputs = other.getAuthenticatorExtensionOutputs();
        return !(this$authenticatorExtensionOutputs == null ? other$authenticatorExtensionOutputs != null : !((Object)this$authenticatorExtensionOutputs).equals(other$authenticatorExtensionOutputs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        result = result * 59 + (this.isSignatureCounterValid() ? 79 : 97);
        RegisteredCredential $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Optional<ClientAssertionExtensionOutputs> $clientExtensionOutputs = this.getClientExtensionOutputs();
        result = result * 59 + ($clientExtensionOutputs == null ? 43 : ((Object)$clientExtensionOutputs).hashCode());
        Optional<AuthenticatorAssertionExtensionOutputs> $authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        result = result * 59 + ($authenticatorExtensionOutputs == null ? 43 : ((Object)$authenticatorExtensionOutputs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssertionResult(success=" + this.isSuccess() + ", credential=" + this.getCredential() + ", username=" + this.getUsername() + ", signatureCount=" + this.getSignatureCount() + ", signatureCounterValid=" + this.isSignatureCounterValid() + ", clientExtensionOutputs=" + this.getClientExtensionOutputs() + ", authenticatorExtensionOutputs=" + this.getAuthenticatorExtensionOutputs() + ")";
    }

    static class AssertionResultBuilder {
        @Generated
        private boolean success;
        @Generated
        private RegisteredCredential credential;
        @Generated
        private String username;
        @Generated
        private long signatureCount;
        @Generated
        private boolean signatureCounterValid;
        @Generated
        private ClientAssertionExtensionOutputs clientExtensionOutputs;
        @Generated
        private AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs;

        @Generated
        AssertionResultBuilder() {
        }

        @Generated
        public AssertionResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        @Generated
        public AssertionResultBuilder credential(RegisteredCredential credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public AssertionResultBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        @Generated
        public AssertionResultBuilder signatureCount(long signatureCount) {
            this.signatureCount = signatureCount;
            return this;
        }

        @Generated
        public AssertionResultBuilder signatureCounterValid(boolean signatureCounterValid) {
            this.signatureCounterValid = signatureCounterValid;
            return this;
        }

        @Generated
        public AssertionResultBuilder clientExtensionOutputs(ClientAssertionExtensionOutputs clientExtensionOutputs) {
            this.clientExtensionOutputs = clientExtensionOutputs;
            return this;
        }

        @Generated
        public AssertionResultBuilder authenticatorExtensionOutputs(AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs) {
            this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
            return this;
        }

        @Generated
        public AssertionResult build() {
            return new AssertionResult(this.success, this.credential, this.username, this.signatureCount, this.signatureCounterValid, this.clientExtensionOutputs, this.authenticatorExtensionOutputs);
        }

        @Generated
        public String toString() {
            return "AssertionResult.AssertionResultBuilder(success=" + this.success + ", credential=" + this.credential + ", username=" + this.username + ", signatureCount=" + this.signatureCount + ", signatureCounterValid=" + this.signatureCounterValid + ", clientExtensionOutputs=" + this.clientExtensionOutputs + ", authenticatorExtensionOutputs=" + this.authenticatorExtensionOutputs + ")";
        }

        public static class MandatoryStages {
            private final AssertionResultBuilder builder = new AssertionResultBuilder();

            public Step2 success(boolean success) {
                this.builder.success(success);
                return new Step2();
            }

            public class Step2 {
                public Step3 credential(RegisteredCredential credential) {
                    MandatoryStages.this.builder.credential(credential);
                    return new Step3();
                }
            }

            public class Step7 {
                public AssertionResultBuilder assertionExtensionOutputs(AuthenticatorAssertionExtensionOutputs authenticatorExtensionOutputs) {
                    return MandatoryStages.this.builder.authenticatorExtensionOutputs(authenticatorExtensionOutputs);
                }
            }

            public class Step6 {
                public Step7 clientExtensionOutputs(ClientAssertionExtensionOutputs clientExtensionOutputs) {
                    MandatoryStages.this.builder.clientExtensionOutputs(clientExtensionOutputs);
                    return new Step7();
                }
            }

            public class Step5 {
                public Step6 signatureCounterValid(boolean signatureCounterValid) {
                    MandatoryStages.this.builder.signatureCounterValid(signatureCounterValid);
                    return new Step6();
                }
            }

            public class Step4 {
                public Step5 signatureCount(long signatureCount) {
                    MandatoryStages.this.builder.signatureCount(signatureCount);
                    return new Step5();
                }
            }

            public class Step3 {
                public Step4 username(String username) {
                    MandatoryStages.this.builder.username(username);
                    return new Step4();
                }
            }
        }
    }
}

