/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CertificateParser;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorRegistrationExtensionOutputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class RegistrationResult {
    @JsonProperty
    private final PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> credential;
    private final boolean attestationTrusted;
    @NonNull
    private final AttestationType attestationType;
    private final List<X509Certificate> attestationTrustPath;

    RegistrationResult(PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> credential, boolean attestationTrusted, @NonNull AttestationType attestationType, Optional<List<X509Certificate>> attestationTrustPath) {
        if (attestationType == null) {
            throw new NullPointerException("attestationType is marked non-null but is null");
        }
        this.credential = credential;
        this.attestationTrusted = attestationTrusted;
        this.attestationType = attestationType;
        this.attestationTrustPath = attestationTrustPath.orElse(null);
    }

    @JsonCreator
    private static RegistrationResult fromJson(@JsonProperty(value="credential") @NonNull PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> credential, @JsonProperty(value="attestationTrusted") boolean attestationTrusted, @JsonProperty(value="attestationType") @NonNull AttestationType attestationType, @JsonProperty(value="attestationTrustPath") @NonNull Optional<List<String>> attestationTrustPath) {
        if (credential == null) {
            throw new NullPointerException("credential is marked non-null but is null");
        }
        if (attestationType == null) {
            throw new NullPointerException("attestationType is marked non-null but is null");
        }
        if (attestationTrustPath == null) {
            throw new NullPointerException("attestationTrustPath is marked non-null but is null");
        }
        return new RegistrationResult(credential, attestationTrusted, attestationType, attestationTrustPath.map(atp -> atp.stream().map(pem -> {
            try {
                return CertificateParser.parsePem((String)pem);
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList())));
    }

    @Deprecated
    @JsonIgnore
    public boolean isBackupEligible() {
        return this.credential.getResponse().getParsedAuthenticatorData().getFlags().BE;
    }

    @Deprecated
    @JsonIgnore
    public boolean isBackedUp() {
        return this.credential.getResponse().getParsedAuthenticatorData().getFlags().BS;
    }

    @JsonIgnore
    public long getSignatureCount() {
        return this.credential.getResponse().getParsedAuthenticatorData().getSignatureCounter();
    }

    @JsonIgnore
    public PublicKeyCredentialDescriptor getKeyId() {
        return PublicKeyCredentialDescriptor.builder().id(this.credential.getId()).type(this.credential.getType()).transports(this.credential.getResponse().getTransports()).build();
    }

    @JsonIgnore
    public ByteArray getAaguid() {
        return this.credential.getResponse().getAttestation().getAuthenticatorData().getAttestedCredentialData().get().getAaguid();
    }

    @JsonIgnore
    public ByteArray getPublicKeyCose() {
        return this.credential.getResponse().getAttestation().getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey();
    }

    @JsonIgnore
    public Optional<ClientRegistrationExtensionOutputs> getClientExtensionOutputs() {
        return Optional.ofNullable(this.credential.getClientExtensionResults()).filter(ceo -> !ceo.getExtensionIds().isEmpty());
    }

    @JsonIgnore
    public Optional<AuthenticatorRegistrationExtensionOutputs> getAuthenticatorExtensionOutputs() {
        return AuthenticatorRegistrationExtensionOutputs.fromAuthenticatorData(this.credential.getResponse().getParsedAuthenticatorData());
    }

    @JsonIgnore
    public Optional<Boolean> isDiscoverable() {
        return this.getClientExtensionOutputs().flatMap(outputs -> outputs.getCredProps()).flatMap(credProps -> credProps.getRk());
    }

    @JsonIgnore
    public Optional<List<X509Certificate>> getAttestationTrustPath() {
        return Optional.ofNullable(this.attestationTrustPath);
    }

    @JsonProperty(value="attestationTrustPath")
    private Optional<List<String>> getAttestationTrustPathJson() {
        return this.getAttestationTrustPath().map(x5c -> x5c.stream().map(cert -> {
            try {
                return new ByteArray(cert.getEncoded()).getBase64();
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()));
    }

    @Generated
    public boolean isAttestationTrusted() {
        return this.attestationTrusted;
    }

    @NonNull
    @Generated
    public AttestationType getAttestationType() {
        return this.attestationType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistrationResult)) {
            return false;
        }
        RegistrationResult other = (RegistrationResult)o;
        if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
            return false;
        }
        PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> this$credential = this.credential;
        PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> other$credential = other.credential;
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        AttestationType this$attestationType = this.getAttestationType();
        AttestationType other$attestationType = other.getAttestationType();
        if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
            return false;
        }
        Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
        Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
        return !(this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
        PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> $credential = this.credential;
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        AttestationType $attestationType = this.getAttestationType();
        result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
        Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
        result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegistrationResult(credential=" + this.credential + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrustPath=" + this.getAttestationTrustPath() + ")";
    }
}

