/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.yubico.internal.util.BinaryUtil;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.data.AttestedCredentialData;
import com.yubico.webauthn.data.AuthenticatorDataFlags;
import com.yubico.webauthn.data.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonSerialize(using=JsonSerializer.class)
public final class AuthenticatorData {
    @NonNull
    private final ByteArray bytes;
    @NonNull
    private final transient AuthenticatorDataFlags flags;
    @JsonIgnore
    private final transient AttestedCredentialData attestedCredentialData;
    @JsonIgnore
    private final transient CBORObject extensions;
    private static final int RP_ID_HASH_INDEX = 0;
    private static final int RP_ID_HASH_END = 32;
    private static final int FLAGS_INDEX = 32;
    private static final int FLAGS_END = 33;
    private static final int COUNTER_INDEX = 33;
    private static final int COUNTER_END = 37;
    private static final int FIXED_LENGTH_PART_END_INDEX = 37;

    @JsonCreator
    public AuthenticatorData(@NonNull ByteArray bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        ExceptionUtil.assertTrue((bytes.size() >= 37 ? 1 : 0) != 0, (String)"%s byte array must be at least %d bytes, was %d: %s", (Object[])new Object[]{AuthenticatorData.class.getSimpleName(), 37, bytes.size(), bytes.getBase64Url()});
        this.bytes = bytes;
        byte[] rawBytes = bytes.getBytes();
        this.flags = new AuthenticatorDataFlags(rawBytes[32]);
        if (this.flags.AT) {
            VariableLengthParseResult parseResult = AuthenticatorData.parseAttestedCredentialData(this.flags, Arrays.copyOfRange(rawBytes, 37, rawBytes.length));
            this.attestedCredentialData = parseResult.getAttestedCredentialData();
            this.extensions = parseResult.getExtensions();
        } else if (this.flags.ED) {
            this.attestedCredentialData = null;
            this.extensions = AuthenticatorData.parseExtensions(Arrays.copyOfRange(rawBytes, 37, rawBytes.length));
        } else {
            this.attestedCredentialData = null;
            this.extensions = null;
        }
    }

    @JsonProperty(value="rpIdHash")
    public ByteArray getRpIdHash() {
        return new ByteArray(Arrays.copyOfRange(this.bytes.getBytes(), 0, 32));
    }

    public long getSignatureCounter() {
        return BinaryUtil.getUint32((byte[])Arrays.copyOfRange(this.bytes.getBytes(), 33, 37));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static VariableLengthParseResult parseAttestedCredentialData(AuthenticatorDataFlags flags, byte[] bytes) {
        CBORObject extensions;
        int CREDENTIAL_ID_END;
        int L;
        boolean AAGUID_INDEX = false;
        int AAGUID_END = 16;
        int CREDENTIAL_ID_LENGTH_INDEX = 16;
        int CREDENTIAL_ID_LENGTH_END = 18;
        ExceptionUtil.assertTrue((bytes.length >= 18 ? 1 : 0) != 0, (String)"Attested credential data must contain at least %d bytes, was %d: %s", (Object[])new Object[]{18, bytes.length, new ByteArray(bytes)});
        byte[] credentialIdLengthBytes = Arrays.copyOfRange(bytes, 16, 18);
        try {
            L = BinaryUtil.getUint16((byte[])credentialIdLengthBytes);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid credential ID length bytes: " + Arrays.asList(new byte[][]{credentialIdLengthBytes}), e);
        }
        int CREDENTIAL_ID_INDEX = 18;
        int CREDENTIAL_PUBLIC_KEY_INDEX = CREDENTIAL_ID_END = 18 + L;
        int CREDENTIAL_PUBLIC_KEY_AND_EXTENSION_DATA_END = bytes.length;
        ExceptionUtil.assertTrue((bytes.length >= CREDENTIAL_ID_END ? 1 : 0) != 0, (String)"Expected credential ID of length %d, but attested credential data and extension data is only %d bytes: %s", (Object[])new Object[]{CREDENTIAL_ID_END, bytes.length, new ByteArray(bytes)});
        ByteArrayInputStream indefiniteLengthBytes = new ByteArrayInputStream(Arrays.copyOfRange(bytes, CREDENTIAL_PUBLIC_KEY_INDEX, CREDENTIAL_PUBLIC_KEY_AND_EXTENSION_DATA_END));
        CBORObject credentialPublicKey = CBORObject.Read((InputStream)indefiniteLengthBytes);
        if (indefiniteLengthBytes.available() > 0) {
            if (!flags.ED) throw new IllegalArgumentException(String.format("Flags indicate no extension data, but %d bytes remain after attested credential data.", indefiniteLengthBytes.available()));
            try {
                extensions = CBORObject.Read((InputStream)indefiniteLengthBytes);
                return new VariableLengthParseResult(AttestedCredentialData.builder().aaguid(new ByteArray(Arrays.copyOfRange(bytes, 0, 16))).credentialId(new ByteArray(Arrays.copyOfRange(bytes, 18, CREDENTIAL_ID_END))).credentialPublicKey(new ByteArray(credentialPublicKey.EncodeToBytes())).build(), extensions);
            }
            catch (CBORException e) {
                throw new IllegalArgumentException("Failed to parse extension data", e);
            }
        } else {
            if (flags.ED) {
                throw new IllegalArgumentException("Flags indicate there should be extension data, but no bytes remain after attested credential data.");
            }
            extensions = null;
        }
        return new VariableLengthParseResult(AttestedCredentialData.builder().aaguid(new ByteArray(Arrays.copyOfRange(bytes, 0, 16))).credentialId(new ByteArray(Arrays.copyOfRange(bytes, 18, CREDENTIAL_ID_END))).credentialPublicKey(new ByteArray(credentialPublicKey.EncodeToBytes())).build(), extensions);
    }

    private static CBORObject parseExtensions(byte[] bytes) {
        try {
            return CBORObject.DecodeFromBytes((byte[])bytes);
        }
        catch (CBORException e) {
            throw new IllegalArgumentException("Failed to parse extension data", e);
        }
    }

    public Optional<AttestedCredentialData> getAttestedCredentialData() {
        return Optional.ofNullable(this.attestedCredentialData);
    }

    public Optional<CBORObject> getExtensions() {
        return Optional.ofNullable(this.extensions).map(JacksonCodecs::deepCopy);
    }

    @NonNull
    @Generated
    public ByteArray getBytes() {
        return this.bytes;
    }

    @NonNull
    @Generated
    public AuthenticatorDataFlags getFlags() {
        return this.flags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorData)) {
            return false;
        }
        AuthenticatorData other = (AuthenticatorData)o;
        ByteArray this$bytes = this.getBytes();
        ByteArray other$bytes = other.getBytes();
        return !(this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorData(bytes=" + this.getBytes() + ", flags=" + this.getFlags() + ", attestedCredentialData=" + this.getAttestedCredentialData() + ", extensions=" + this.getExtensions() + ")";
    }

    static class JsonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<AuthenticatorData> {
        JsonSerializer() {
        }

        public void serialize(AuthenticatorData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getBytes().getBase64Url());
        }
    }

    private static final class VariableLengthParseResult {
        private final AttestedCredentialData attestedCredentialData;
        private final CBORObject extensions;

        @Generated
        public VariableLengthParseResult(AttestedCredentialData attestedCredentialData, CBORObject extensions) {
            this.attestedCredentialData = attestedCredentialData;
            this.extensions = extensions;
        }

        @Generated
        public AttestedCredentialData getAttestedCredentialData() {
            return this.attestedCredentialData;
        }

        @Generated
        public CBORObject getExtensions() {
            return this.extensions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableLengthParseResult)) {
                return false;
            }
            VariableLengthParseResult other = (VariableLengthParseResult)o;
            AttestedCredentialData this$attestedCredentialData = this.getAttestedCredentialData();
            AttestedCredentialData other$attestedCredentialData = other.getAttestedCredentialData();
            if (this$attestedCredentialData == null ? other$attestedCredentialData != null : !((Object)this$attestedCredentialData).equals(other$attestedCredentialData)) {
                return false;
            }
            CBORObject this$extensions = this.getExtensions();
            CBORObject other$extensions = other.getExtensions();
            return !(this$extensions == null ? other$extensions != null : !this$extensions.equals(other$extensions));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AttestedCredentialData $attestedCredentialData = this.getAttestedCredentialData();
            result = result * 59 + ($attestedCredentialData == null ? 43 : ((Object)$attestedCredentialData).hashCode());
            CBORObject $extensions = this.getExtensions();
            result = result * 59 + ($extensions == null ? 43 : $extensions.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthenticatorData.VariableLengthParseResult(attestedCredentialData=" + this.getAttestedCredentialData() + ", extensions=" + this.getExtensions() + ")";
        }
    }
}

